/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mmorpg;

import com.robertx22.library_of_exile.events.base.EventConsumer;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.utils.Watch;
import com.robertx22.mine_and_slash.a_libraries.curios.CurioEvents;
import com.robertx22.mine_and_slash.a_libraries.neat.NeatForgeConfig;
import com.robertx22.mine_and_slash.aoe_data.GeneratedData;
import com.robertx22.mine_and_slash.aoe_data.database.boss_spell.BossSpells;
import com.robertx22.mine_and_slash.aoe_data.database.prophecies.ProphecyStarts;
import com.robertx22.mine_and_slash.aoe_data.database.stat_conditions.StatConditions;
import com.robertx22.mine_and_slash.aoe_data.database.stat_effects.StatEffects;
import com.robertx22.mine_and_slash.aoe_data.database.stats.AscensionStats;
import com.robertx22.mine_and_slash.aoe_data.database.stats.Stats;
import com.robertx22.mine_and_slash.characters.PlayerStats;
import com.robertx22.mine_and_slash.config.forge.ClientConfigs;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.database.data.league.LeagueMechanics;
import com.robertx22.mine_and_slash.database.data.loot_chest.base.LootChests;
import com.robertx22.mine_and_slash.database.data.profession.ProfessionEvents;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.EffectCondition;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.stats.layers.StatLayers;
import com.robertx22.mine_and_slash.database.data.stats.priority.StatPriority;
import com.robertx22.mine_and_slash.database.data.stats.types.special.SpecialStats;
import com.robertx22.mine_and_slash.database.registrators.Currencies;
import com.robertx22.mine_and_slash.database.registry.ExileDBInit;
import com.robertx22.mine_and_slash.gui.SocketTooltip;
import com.robertx22.mine_and_slash.maps.MapEvents;
import com.robertx22.mine_and_slash.mmorpg.DerivedRegistries;
import com.robertx22.mine_and_slash.mmorpg.ForgeEvents;
import com.robertx22.mine_and_slash.mmorpg.LifeCycleEvents;
import com.robertx22.mine_and_slash.mmorpg.event_registers.CommonEvents;
import com.robertx22.mine_and_slash.mmorpg.init.ClientInit;
import com.robertx22.mine_and_slash.mmorpg.registers.client.KeybindsRegister;
import com.robertx22.mine_and_slash.mmorpg.registers.client.RenderRegister;
import com.robertx22.mine_and_slash.mmorpg.registers.client.S2CPacketRegister;
import com.robertx22.mine_and_slash.mmorpg.registers.common.C2SPacketRegister;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashCapabilities;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashItemTags;
import com.robertx22.mine_and_slash.mmorpg.registers.deferred_wrapper.SlashDeferred;
import com.robertx22.mine_and_slash.tags.ModTags;
import com.robertx22.mine_and_slash.uncommon.coins.Coin;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.action.StatEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.condition.StatCondition;
import java.text.DecimalFormat;
import java.util.function.Consumer;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import top.theillusivec4.curios.api.SlotTypeMessage;

@Mod(value="mmorpg")
public class MMORPG {
    public static boolean RUN_DEV_TOOLS = false;
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    public static boolean RUN_DEV_TOOLS_REMOVE_WHEN_DONE = RUN_DEV_TOOLS;
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel NETWORK = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("mmorpg", "main"), () -> "1", "1"::equals, "1"::equals);

    public static String formatNumber(float num) {
        if (num < 10.0f) {
            return DECIMAL_FORMAT.format(num);
        }
        return "" + (int)num;
    }

    public MMORPG() {
        Watch watch = new Watch();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerContainer.spec, NeatForgeConfig.defaultConfigName(ModConfig.Type.SERVER, "mine_and_slash"));
        ExileEvents.CHECK_IF_DEV_TOOLS_SHOULD_RUN.register((EventConsumer)new EventConsumer<ExileEvents.OnCheckIsDevToolsRunning>(){

            public void accept(ExileEvents.OnCheckIsDevToolsRunning event) {
                event.run = RUN_DEV_TOOLS;
            }
        });
        Coin.init();
        StatPriority.init();
        StackSaving.init();
        StatEffect.init();
        StatCondition.loadclass();
        ForgeEvents.registerForgeEvent(RegisterClientTooltipComponentFactoriesEvent.class, x -> x.register(SocketTooltip.SocketComponent.class, SocketTooltip::new));
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ForgeEvents.registerForgeEvent(AddReloadListenerEvent.class, event -> ExileRegistryType.registerJsonListeners((AddReloadListenerEvent)event));
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            NeatForgeConfig.register();
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfigs.clientSpec, NeatForgeConfig.defaultConfigName(ModConfig.Type.CLIENT, "mine_and_slash"));
            bus.addListener(ClientInit::onInitializeClient);
            ForgeEvents.registerForgeEvent(RegisterKeyMappingsEvent.class, x -> KeybindsRegister.register(x));
            FMLJavaModLoadingContext.get().getModEventBus().addListener(x -> RenderRegister.regRenders(x));
        });
        bus.addListener(this::commonSetupEvent);
        bus.addListener(this::interMod);
        CurioEvents.reg();
        ModTags.init();
        StatLayers.init();
        StatEffects.addSerializers();
        StatConditions.loadClass();
        Stats.loadClass();
        AscensionStats.init();
        ExileDBInit.initRegistries();
        SpecialStats.init();
        SlashDeferred.registerDefferedAtStartOfModLoading();
        MapField.init();
        EffectCondition.init();
        SlashItemTags.init();
        ExileDBInit.registerAllItems();
        PlayerStats.register();
        PlayerStats.initialize();
        CommonEvents.register();
        C2SPacketRegister.register();
        S2CPacketRegister.register();
        LifeCycleEvents.register();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.LOW, (Consumer)new Consumer<GatherDataEvent>(){

            @Override
            public void accept(GatherDataEvent x) {
                for (ExileRegistryType type : ExileRegistryType.getAllInRegisterOrder()) {
                    x.getGenerator().addProvider(true, (DataProvider)type.getDatapackGenerator());
                }
            }
        });
        MapEvents.init();
        ProfessionEvents.init();
        DerivedRegistries.init();
        watch.print("Mine and slash mod initialization ");
    }

    public void interMod(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("ring").size(2).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("necklace").size(1).build());
    }

    public void commonSetupEvent(FMLCommonSetupEvent event) {
        new Currencies().registerAll();
        GeneratedData.addAllObjectsToGenerate();
        BossSpells.init();
        LeagueMechanics.init();
        LootChests.init();
        new ProphecyStarts().registerAll();
        SlashCapabilities.register();
    }

    public static void devToolsErrorLog(String string) {
        if (RUN_DEV_TOOLS) {
            try {
                throw new Exception(string);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void logError(String s) {
        try {
            throw new Exception(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

