/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mixins;

import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.mixin_methods.TooltipMethod;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class}, priority=0x7FFFFFFF)
public abstract class ItemStackMixin {
    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void hookLoot(Level world, Player p, InteractionHand pUsedHand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        try {
            ItemStack stack = (ItemStack)this;
            if (WorldUtils.isDungeonWorld(world) && ServerContainer.get().isItemBanned(stack.m_41720_())) {
                cir.setReturnValue((Object)InteractionResultHolder.m_19100_((Object)stack));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="RETURN")})
    private void getTooltip(Player entity, TooltipFlag tooltipContext, CallbackInfoReturnable<List<Component>> list) {
        ItemStack stack = (ItemStack)this;
        TooltipMethod.getTooltip(stack, entity, tooltipContext, list);
    }
}

