/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mixin_methods;

import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.database.data.currency.IItemAsCurrency;
import com.robertx22.mine_and_slash.database.data.gear_slots.GearSlot;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipContext;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.prof_tool.ProfessionToolData;
import com.robertx22.mine_and_slash.saveclasses.unit.Unit;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.interfaces.INeedsNBT;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class TooltipMethod {
    public static List<Component> getTooltip(ItemStack stack, Player entity, TooltipFlag tooltipContext, CallbackInfoReturnable<List<Component>> list) {
        List<Component> tooltip = (List<Component>)list.getReturnValue();
        boolean addCurrencyTooltip = stack.m_41720_() instanceof IItemAsCurrency;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        try {
            GearItemData gear;
            if (Screen.m_96637_() && (gear = (GearItemData)StackSaving.GEARS.loadFrom(stack)) != null) {
                tooltip.addAll(gear.getEnchantCompatTooltip(stack));
                return tooltip;
            }
            if (player == null || player.m_9236_() == null) {
                return tooltip;
            }
            EntityData unitdata = Load.Unit((Entity)player);
            if (unitdata == null) {
                return tooltip;
            }
            Unit unit = unitdata.getUnit();
            if (unit == null) {
                return tooltip;
            }
            if (!Database.areDatapacksLoaded((Level)player.m_9236_())) {
                return tooltip;
            }
            TooltipContext ctx = new TooltipContext(stack, tooltip, unitdata);
            boolean hasdata = false;
            if (stack.m_41782_()) {
                MutableComponent broken;
                ICommonDataItem data = ICommonDataItem.load(stack);
                if (data != null) {
                    data.BuildTooltip(ctx);
                    hasdata = true;
                }
                if ((broken = TooltipUtils.itemBrokenText(stack, data)) != null) {
                    tooltip.add((Component)broken);
                }
                if (StackSaving.TOOL.has(stack)) {
                    ((ProfessionToolData)StackSaving.TOOL.loadFrom(stack)).BuildTooltip(ctx);
                }
            }
            if (!hasdata) {
                GearSlot slot = GearSlot.getSlotOf(stack.m_41720_());
                if (slot != null) {
                    tooltip.add((Component)TooltipUtils.gearSlot(slot));
                    tooltip.addAll(TooltipUtils.splitLongText(Chats.SOULLESS_GEAR_INFO.locName()));
                    if (Screen.m_96638_()) {
                        tooltip.addAll(TooltipUtils.splitLongText(Chats.SOULLESS_GEAR_MORE_INFO.locName()));
                    }
                }
                if (stack.m_41720_() instanceof INeedsNBT) {
                    tooltip.addAll(TooltipUtils.cutIfTooLong(Chats.ITEM_NON_NBT.locName().m_130940_(ChatFormatting.RED)));
                }
            }
            if (addCurrencyTooltip) {
                IItemAsCurrency currency = (IItemAsCurrency)stack.m_41720_();
                currency.currencyEffect(stack).addToTooltip(tooltip);
            }
            tooltip = TooltipUtils.removeDoubleBlankLines(tooltip);
            tooltip = TooltipUtils.splitLongText(tooltip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tooltip;
    }
}

