/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mixin_methods;

import com.robertx22.library_of_exile.utils.SoundUtils;
import com.robertx22.mine_and_slash.database.data.auto_item.AutoItem;
import com.robertx22.mine_and_slash.database.data.currency.IItemAsCurrency;
import com.robertx22.mine_and_slash.database.data.currency.loc_reqs.LocReqContext;
import com.robertx22.mine_and_slash.database.data.profession.ExplainedResult;
import com.robertx22.mine_and_slash.database.data.profession.items.CraftedSoulItem;
import com.robertx22.mine_and_slash.database.data.runewords.RuneWord;
import com.robertx22.mine_and_slash.mmorpg.ForgeEvents;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.SlashItems;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.SocketData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.jewel.JewelItemData;
import com.robertx22.mine_and_slash.saveclasses.stat_soul.StatSoulData;
import com.robertx22.mine_and_slash.saveclasses.stat_soul.StatSoulItem;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import com.robertx22.mine_and_slash.vanilla_mc.items.SoulExtractorItem;
import com.robertx22.mine_and_slash.vanilla_mc.items.TagForceSoulItem;
import com.robertx22.mine_and_slash.vanilla_mc.items.misc.RarityStoneItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ItemStackedOnOtherEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;

public class OnItemInteract {
    static List<ClickFeature> CLICKS = new ArrayList<ClickFeature>();

    public static void register() {
        CLICKS.add(new ClickFeature(){

            @Override
            public Result tryApply(Player player, ItemStack craftedStack, ItemStack currency, Slot slot) {
                if (StackSaving.JEWEL.has(craftedStack)) {
                    ItemStack cost;
                    JewelItemData data = (JewelItemData)StackSaving.JEWEL.loadFrom(craftedStack);
                    if (data.uniq.isCraftableUnique() && (cost = data.uniq.getStackNeededForUpgrade()).m_41720_() == currency.m_41720_() && currency.m_41613_() >= cost.m_41613_() && data.uniq.getCraftedTier().canUpgradeMore()) {
                        data.uniq.upgradeUnique(data);
                        StackSaving.JEWEL.saveTo(craftedStack, (Object)data);
                        currency.m_41774_(cost.m_41613_());
                        return new Result(true).ding();
                    }
                }
                return new Result(false);
            }
        });
        CLICKS.add(new ClickFeature(){

            @Override
            public Result tryApply(Player player, ItemStack craftedStack, ItemStack currency, Slot slot) {
                Item item = currency.m_41720_();
                if (item instanceof TagForceSoulItem) {
                    TagForceSoulItem force = (TagForceSoulItem)item;
                    if (craftedStack.m_41613_() == 1) {
                        CraftedSoulItem i;
                        StatSoulData soul;
                        StatSoulData data = (StatSoulData)StackSaving.STAT_SOULS.loadFrom(craftedStack);
                        if (data != null && data.isArmor()) {
                            data.force_tag = force.tag.tag;
                            data.saveToStack(craftedStack);
                            currency.m_41774_(1);
                            return new Result(true).ding();
                        }
                        Item item2 = craftedStack.m_41720_();
                        if (item2 instanceof CraftedSoulItem && (soul = (i = (CraftedSoulItem)item2).getSoul(craftedStack)) != null && soul.isArmor()) {
                            craftedStack.m_41784_().m_128359_("force_tag", force.tag.tag);
                            currency.m_41774_(1);
                            return new Result(true).ding();
                        }
                    }
                }
                return new Result(false);
            }
        });
        CLICKS.add(new ClickFeature(){

            @Override
            public Result tryApply(Player player, ItemStack craftedStack, ItemStack currency, Slot slot) {
                if (craftedStack.m_41768_() && currency.m_41720_() instanceof RarityStoneItem) {
                    if (!StackSaving.GEARS.has(craftedStack)) {
                        return new Result(false);
                    }
                    RarityStoneItem essence = (RarityStoneItem)currency.m_41720_();
                    SoundUtils.playSound((Entity)player, (SoundEvent)SoundEvents.f_11671_, (float)1.0f, (float)1.0f);
                    int repair = essence.getTotalRepair();
                    craftedStack.m_41721_(craftedStack.m_41773_() - repair);
                    currency.m_41774_(1);
                    return new Result(true).ding();
                }
                return new Result(false);
            }
        });
        CLICKS.add(new ClickFeature(){

            @Override
            public Result tryApply(Player player, ItemStack craftedStack, ItemStack currency, Slot slot) {
                if (currency.m_41720_() instanceof StatSoulItem || currency.m_41720_() instanceof CraftedSoulItem) {
                    StatSoulData data = (StatSoulData)StackSaving.STAT_SOULS.loadFrom(currency);
                    Item item = currency.m_41720_();
                    if (item instanceof CraftedSoulItem) {
                        CraftedSoulItem cs = (CraftedSoulItem)item;
                        data = cs.getSoul(currency);
                    }
                    if (data != null && data.canInsertIntoStack(craftedStack) && craftedStack.m_41613_() == 1) {
                        data.insertAsUnidentifiedOn(craftedStack, player);
                        currency.m_41774_(1);
                        return new Result(true).ding();
                    }
                }
                return new Result(false);
            }
        });
        CLICKS.add(new ClickFeature(){

            @Override
            public Result tryApply(Player player, ItemStack craftedStack, ItemStack currency, Slot slot) {
                if (currency.m_41720_() instanceof IItemAsCurrency) {
                    LocReqContext ctx = new LocReqContext(player, craftedStack, currency);
                    if (!craftedStack.m_41619_()) {
                        ExplainedResult can = ctx.effect.canItemBeModified(ctx);
                        if (can.can) {
                            ItemStack result = ctx.effect.modifyItem((LocReqContext)ctx).stack;
                            craftedStack.m_41774_(1);
                            currency.m_41774_(1);
                            slot.m_5852_(result);
                            return new Result(true);
                        }
                        player.m_213846_(can.answer);
                    }
                }
                return new Result(false);
            }
        });
        CLICKS.add(new ClickFeature(){

            @Override
            public Result tryApply(Player player, ItemStack craftedStack, ItemStack currency, Slot slot) {
                GearItemData gear;
                if (currency.m_41720_() == SlashItems.SOCKET_EXTRACTOR.get() && (gear = (GearItemData)StackSaving.GEARS.loadFrom(craftedStack)) != null && gear.sockets != null && gear.sockets.getSocketed().size() > 0) {
                    try {
                        int index = gear.sockets.lastFilledSocketIndex();
                        if (index > -1) {
                            RuneWord runeword = null;
                            if (gear.sockets.hasRuneWord()) {
                                runeword = gear.sockets.getRuneWord();
                            }
                            SocketData s = gear.sockets.getSocketed().get(index);
                            ItemStack gem = s.getOriginalItemStack();
                            gear.sockets.getSocketed().remove(index);
                            if (gear.sockets.hasRuneWord() && !runeword.hasMatchingRunesToCreate(gear)) {
                                gear.sockets.removeRuneword();
                            }
                            StackSaving.GEARS.saveTo(craftedStack, (Object)gear);
                            PlayerUtils.giveItem(gem, player);
                            currency.m_41774_(1);
                            return new Result(true).ding();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return new Result(false);
            }
        });
        CLICKS.add(new ClickFeature(){

            @Override
            public Result tryApply(Player player, ItemStack craftedStack, ItemStack currency, Slot slot) {
                Item item = currency.m_41720_();
                if (item instanceof SoulExtractorItem) {
                    SoulExtractorItem se = (SoulExtractorItem)item;
                    GearItemData gear = (GearItemData)StackSaving.GEARS.loadFrom(craftedStack);
                    if (gear != null) {
                        try {
                            if (se.canExtract(gear.getRarity())) {
                                StatSoulData soul = new StatSoulData();
                                soul.slot = gear.GetBaseGearType().getGearSlot().GUID();
                                soul.gear = gear;
                                ItemStack soulstack = soul.toStack();
                                SoundUtils.playSound((Entity)player, (SoundEvent)SoundEvents.f_11871_);
                                craftedStack.m_41774_(1);
                                currency.m_41774_(1);
                                PlayerUtils.giveItem(soulstack, player);
                                return new Result(true).ding();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                return new Result(false);
            }
        });
        CLICKS.add(new ClickFeature(){

            @Override
            public Result tryApply(Player player, ItemStack craftedStack, ItemStack currency, Slot slot) {
                GearItemData gear;
                if (currency.m_150930_(SlashItems.SOUL_CLEANER.get()) && (gear = (GearItemData)StackSaving.GEARS.loadFrom(craftedStack)) != null) {
                    try {
                        craftedStack.m_41784_().m_128473_(StackSaving.GEARS.GUID());
                        currency.m_41774_(1);
                        return new Result(true).ding();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return new Result(false);
            }
        });
        ForgeEvents.registerForgeEvent(ItemStackedOnOtherEvent.class, x -> {
            Player player = x.getPlayer();
            if (player.m_9236_().f_46443_) {
                return;
            }
            if (x.getClickAction() != ClickAction.SECONDARY) {
                // empty if block
            }
            ItemStack currency = x.getStackedOnItem();
            ItemStack craftedStack = x.getCarriedItem();
            for (ClickFeature click : CLICKS) {
                Result result = click.tryApply(player, craftedStack, currency, x.getSlot());
                if (result.doDing) {
                    SoundUtils.ding((Level)player.m_9236_(), (BlockPos)player.m_20183_());
                    SoundUtils.playSound((Level)player.m_9236_(), (BlockPos)player.m_20183_(), (SoundEvent)SoundEvents.f_11671_, (float)1.0f, (float)1.0f);
                }
                if (!result.can) continue;
                x.setCanceled(true);
                break;
            }
        });
        ForgeEvents.registerForgeEvent(EntityItemPickupEvent.class, x -> {
            AutoItem auto;
            ItemStack stack = x.getItem().m_32055_();
            if (!StackSaving.GEARS.has(stack) && (!stack.m_41782_() || stack.m_41782_() && !stack.m_41783_().m_128471_("free_souled")) && (auto = AutoItem.get(stack.m_41720_())) != null) {
                stack.m_41784_().m_128379_("free_souled", true);
                StackSaving.GEARS.saveTo(stack, (Object)auto.create(x.getEntity()));
            }
        });
    }

    public static abstract class ClickFeature {
        public abstract Result tryApply(Player var1, ItemStack var2, ItemStack var3, Slot var4);
    }

    static class Result {
        public boolean can;
        private boolean doDing = false;

        public Result(boolean can) {
            this.can = can;
        }

        public Result ding() {
            this.doDing = true;
            return this;
        }
    }
}

