/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mechanics.harvest.currency;

import com.robertx22.mine_and_slash.database.data.currency.base.Currency;
import com.robertx22.mine_and_slash.database.data.currency.base.GearOutcome;
import com.robertx22.mine_and_slash.database.data.currency.loc_reqs.LocReqContext;
import com.robertx22.mine_and_slash.database.data.profession.ExplainedResult;
import com.robertx22.mine_and_slash.mechanics.harvest.HarvestItems;
import com.robertx22.mine_and_slash.mechanics.harvest.currency.BaseHarvestCurrency;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class EntangledUniqueReroll
extends BaseHarvestCurrency {
    @Override
    public Item getSpecialCraftItem() {
        return Items.f_41959_;
    }

    @Override
    public Item getHarvestCraftItem() {
        return HarvestItems.PURPLE_INGOT.get();
    }

    @Override
    public GearOutcome getGoodOutcome() {
        return new GearOutcome(){

            @Override
            public Words getName() {
                return Words.UpgradesUniqueStats;
            }

            @Override
            public GearOutcome.OutcomeType getOutcomeType() {
                return GearOutcome.OutcomeType.GOOD;
            }

            @Override
            public ItemStack modify(LocReqContext ctx, GearItemData gear, ItemStack stack) {
                gear.uniqueStats.increaseAllBy(gear, 10);
                StackSaving.GEARS.saveTo(stack, (Object)gear);
                return stack;
            }

            public int Weight() {
                return 1000;
            }
        };
    }

    @Override
    public int getPotentialLoss() {
        return 1;
    }

    @Override
    public ExplainedResult canBeModified(GearItemData data) {
        if (data.isUnique() && data.uniqueStats != null) {
            return ExplainedResult.success();
        }
        return ExplainedResult.failure((Component)Chats.BE_UNIQUE.locName());
    }

    @Override
    public String locDescForLangFile() {
        return "Either Upgrades unique stats by +10% or Corrupts the Item, making it Unmodifiable.";
    }

    @Override
    public String locNameForLangFile() {
        return "Entangled Orb of Imperfection";
    }

    public String GUID() {
        return "entangled_unique_reroll";
    }

    public int Weight() {
        return Currency.Weights.UBER;
    }
}

