/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mechanics.harvest.currency;

import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.database.data.currency.base.GearOutcome;
import com.robertx22.mine_and_slash.database.data.currency.loc_reqs.LocReqContext;
import com.robertx22.mine_and_slash.database.data.profession.ExplainedResult;
import com.robertx22.mine_and_slash.mechanics.harvest.HarvestItems;
import com.robertx22.mine_and_slash.mechanics.harvest.currency.BaseHarvestCurrency;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class EntangledQuality
extends BaseHarvestCurrency {
    @Override
    public Item getSpecialCraftItem() {
        return Items.f_42415_;
    }

    @Override
    public Item getHarvestCraftItem() {
        return HarvestItems.GREEN_INGOT.get();
    }

    @Override
    public GearOutcome getGoodOutcome() {
        return new GearOutcome(){

            @Override
            public Words getName() {
                return Words.UpgradeQuality;
            }

            @Override
            public GearOutcome.OutcomeType getOutcomeType() {
                return GearOutcome.OutcomeType.GOOD;
            }

            @Override
            public ItemStack modify(LocReqContext ctx, GearItemData data, ItemStack stack) {
                data.setQuality(data.getQuality() + RandomUtils.RandomRange((int)1, (int)5));
                StackSaving.GEARS.saveTo(stack, (Object)data);
                return stack;
            }

            public int Weight() {
                return 1000;
            }
        };
    }

    @Override
    public int getPotentialLoss() {
        return 1;
    }

    @Override
    public ExplainedResult canBeModified(GearItemData data) {
        if (data.getQuality() < 21) {
            return ExplainedResult.success();
        }
        return ExplainedResult.failure((Component)Chats.CANT_GO_ABOVE.locName(21));
    }

    @Override
    public String locDescForLangFile() {
        return "Either Randomly Upgrades Quality of An Item (1-5%) or Corrupts the Item, making it Unmodifiable.";
    }

    @Override
    public String locNameForLangFile() {
        return "Entangled Orb of Quality";
    }

    public String GUID() {
        return "entangled_quality";
    }

    public int Weight() {
        return 1000;
    }
}

