/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mechanics.harvest.currency;

import com.robertx22.mine_and_slash.database.data.currency.base.GearOutcome;
import com.robertx22.mine_and_slash.database.data.currency.loc_reqs.LocReqContext;
import com.robertx22.mine_and_slash.database.data.profession.ExplainedResult;
import com.robertx22.mine_and_slash.mechanics.harvest.HarvestItems;
import com.robertx22.mine_and_slash.mechanics.harvest.currency.BaseHarvestCurrency;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class EntangledPotentialUpgrade
extends BaseHarvestCurrency {
    static int potentialAdd = 25;

    @Override
    public Item getSpecialCraftItem() {
        return Items.f_42417_;
    }

    @Override
    public Item getHarvestCraftItem() {
        return HarvestItems.PURPLE_INGOT.get();
    }

    @Override
    public GearOutcome getGoodOutcome() {
        return new GearOutcome(){

            @Override
            public Words getName() {
                return Words.AddPotential;
            }

            @Override
            public GearOutcome.OutcomeType getOutcomeType() {
                return GearOutcome.OutcomeType.GOOD;
            }

            @Override
            public ItemStack modify(LocReqContext ctx, GearItemData gear, ItemStack stack) {
                gear.setPotential(gear.getPotentialNumber() + potentialAdd);
                StackSaving.GEARS.saveTo(stack, (Object)gear);
                return stack;
            }

            public int Weight() {
                return 2000;
            }
        };
    }

    @Override
    public int getPotentialLoss() {
        return 1;
    }

    @Override
    public ExplainedResult canBeModified(GearItemData data) {
        return ExplainedResult.success();
    }

    @Override
    public String locDescForLangFile() {
        return "Either Adds " + potentialAdd + " Potential to the item or Corrupts the Item, making it Unmodifiable.";
    }

    @Override
    public String locNameForLangFile() {
        return "Entangled Orb of Potential";
    }

    public String GUID() {
        return "entangled_potential";
    }

    public int Weight() {
        return 250;
    }
}

