/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mechanics.harvest.currency;

import com.robertx22.mine_and_slash.database.data.currency.base.GearCurrency;
import com.robertx22.mine_and_slash.database.data.currency.base.GearOutcome;
import com.robertx22.mine_and_slash.database.data.currency.base.IShapedRecipe;
import com.robertx22.mine_and_slash.database.data.currency.loc_reqs.LocReqContext;
import com.robertx22.mine_and_slash.database.data.league.LeagueMechanics;
import com.robertx22.mine_and_slash.loot.req.DropRequirement;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.Arrays;
import java.util.List;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class BaseHarvestCurrency
extends GearCurrency
implements IShapedRecipe {
    @Override
    public final DropRequirement getDropReq() {
        return DropRequirement.Builder.of().setOnlyDropsInLeague(LeagueMechanics.HARVEST.GUID()).build();
    }

    public abstract Item getSpecialCraftItem();

    public abstract Item getHarvestCraftItem();

    @Override
    public ShapedRecipeBuilder getRecipe() {
        return this.shaped((ItemLike)this.getCurrencyItem()).m_126127_(Character.valueOf('X'), (ItemLike)this.getSpecialCraftItem()).m_126127_(Character.valueOf('Y'), (ItemLike)this.getHarvestCraftItem()).m_126130_("YYY").m_126130_("YXY").m_126130_("YYY").m_126132_("player_level", this.trigger());
    }

    @Override
    public List<GearOutcome> getOutcomes() {
        return Arrays.asList(new GearOutcome(){

            @Override
            public Words getName() {
                return Words.CorruptsItemHarvest;
            }

            @Override
            public GearOutcome.OutcomeType getOutcomeType() {
                return GearOutcome.OutcomeType.BAD;
            }

            @Override
            public ItemStack modify(LocReqContext ctx, GearItemData gear, ItemStack stack) {
                gear.data.set(GearItemData.KEYS.CORRUPT, true);
                StackSaving.GEARS.saveTo(stack, (Object)gear);
                return stack;
            }

            public int Weight() {
                return 1000;
            }
        }, this.getGoodOutcome());
    }

    public abstract GearOutcome getGoodOutcome();

    @Override
    public int getPotentialLoss() {
        return 0;
    }
}

