/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.maps.spawned_map_mobs;

import com.robertx22.library_of_exile.registry.IWeighted;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.tags.ModTag;
import com.robertx22.mine_and_slash.tags.TagList;
import com.robertx22.mine_and_slash.tags.all.MobTags;
import com.robertx22.mine_and_slash.tags.imp.MobTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.registries.ForgeRegistries;

public class SpawnedMob
implements IWeighted {
    public String type;
    int weight = 1000;
    public TagList<MobTag> tags = new TagList((ModTag[])new MobTag[0]);
    public boolean canBeBoss = false;

    public SpawnedMob(EntityType<? extends Mob> type, int weight) {
        this.type = ForgeRegistries.ENTITY_TYPES.getKey(type).toString();
        this.weight = weight;
    }

    public static SpawnedMob random(MapData map) {
        return (SpawnedMob)RandomUtils.weightedRandom(map.getMobSpawns().mobs);
    }

    public EntityType getType() {
        return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(this.type));
    }

    public SpawnedMob setRanged() {
        this.tags.add(MobTags.RANGED);
        return this;
    }

    public SpawnedMob setNether() {
        this.tags.add(MobTags.NETHER);
        return this;
    }

    public SpawnedMob setUndead() {
        this.tags.add(MobTags.UNDEAD);
        return this;
    }

    public SpawnedMob setSpider() {
        this.tags.add(MobTags.SPIDER);
        return this;
    }

    public SpawnedMob setFire() {
        this.tags.add(MobTags.FIRE);
        return this;
    }

    public SpawnedMob setCanBeBoss(Boolean bool) {
        this.canBeBoss = bool;
        return this;
    }

    public int Weight() {
        return this.weight;
    }
}

