/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.maps.processors.reward;

import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.maps.generator.ChunkProcessData;
import com.robertx22.mine_and_slash.maps.processors.DataProcessor;
import com.robertx22.mine_and_slash.maps.processors.reward.ModLootTables;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;

public class ChestProcessor
extends DataProcessor {
    public ChestProcessor() {
        super("chest", DataProcessor.Type.EQUALS);
        this.detectIds.add("big_chest");
        this.detectIds.add("puzzle");
    }

    @Override
    public boolean canSpawnLeagueMechanic() {
        return false;
    }

    @Override
    public void processImplementation(String key, BlockPos pos, Level world, ChunkProcessData data) {
        boolean isTrapped = this.detectIds.contains("trap");
        boolean useVanilla = RandomUtils.roll((int)20);
        if (isTrapped) {
            world.m_7731_(pos, Blocks.f_50325_.m_49966_(), 2);
        } else {
            world.m_7731_(pos, Blocks.f_50087_.m_49966_(), 2);
        }
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)tile;
            ResourceLocation table = ModLootTables.TIER_1_DUNGEON_CHEST;
            MapData map = Load.mapAt(world, pos);
            if (map != null) {
                float lvm = LevelUtils.getMaxLevelMultiplier(map.map.lvl);
                if (lvm > 0.3f) {
                    table = ModLootTables.TIER_2_DUNGEON_CHEST;
                }
                if (lvm > 0.5f) {
                    table = ModLootTables.TIER_3_DUNGEON_CHEST;
                }
                if (lvm > 0.7f) {
                    table = ModLootTables.TIER_4_DUNGEON_CHEST;
                }
                if (lvm > 0.9f) {
                    table = ModLootTables.TIER_5_DUNGEON_CHEST;
                }
            }
            ChestBlockEntity.m_222766_((BlockGetter)world, (RandomSource)world.m_213780_(), (BlockPos)pos, (ResourceLocation)table);
        } else {
            ExileLog.get().warn("Chest gen failed, tile not instanceof vanilla chest.", new Object[0]);
        }
    }
}

