/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.maps.processors.mob;

import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.maps.generator.ChunkProcessData;
import com.robertx22.mine_and_slash.maps.processors.DataProcessor;
import com.robertx22.mine_and_slash.maps.processors.helpers.MobBuilder;
import com.robertx22.mine_and_slash.maps.spawned_map_mobs.SpawnedMob;
import com.robertx22.mine_and_slash.tags.imp.MobTag;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.StringUTIL;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class ComplexMobProcessor
extends DataProcessor {
    public ComplexMobProcessor() {
        super("spawn", DataProcessor.Type.CONTAINS);
    }

    @Override
    public boolean canSpawnLeagueMechanic() {
        return true;
    }

    @Override
    public void processImplementation(String key, BlockPos pos, Level world, ChunkProcessData data) {
        try {
            MapData map = Load.mapAt(world, pos);
            String[] parts = StringUTIL.split(key, ";");
            GearRarity rarity = null;
            boolean isBoss = false;
            EntityType type = null;
            Stream<SpawnedMob> filter = null;
            int amount = 1;
            for (String x2 : parts) {
                int am = 0;
                try {
                    am = Integer.parseInt(x2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (am <= 0) continue;
                amount = am;
            }
            for (String x2 : parts) {
                if (!ExileDB.GearRarities().isRegistered(x2)) continue;
                rarity = (GearRarity)ExileDB.GearRarities().get(x2);
            }
            for (String x2 : parts) {
                if (!x2.equals("boss")) continue;
                isBoss = true;
            }
            if (rarity == null) {
                rarity = (GearRarity)ExileDB.GearRarities().random();
            }
            for (String x2 : parts) {
                ResourceLocation loc = new ResourceLocation(x2);
                if (!ForgeRegistries.ENTITY_TYPES.containsKey(loc)) continue;
                type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(loc);
            }
            if (type == null) {
                for (String x2 : parts) {
                    for (MobTag tag : MobTag.getAll()) {
                        if (!x2.equals(tag.GUID())) continue;
                        filter = map.getMobSpawns().mobs.stream().filter(m -> m.tags.contains(tag));
                    }
                }
            }
            if (filter == null) {
                filter = map.getMobSpawns().mobs.stream().filter(x -> true);
            }
            if (type == null) {
                if (isBoss) {
                    filter = filter.filter(m -> m.canBeBoss);
                }
                type = ((SpawnedMob)RandomUtils.weightedRandom((Collection)filter.collect(Collectors.toList()))).getType();
            }
            int finalAmount = amount;
            GearRarity finalRarity = rarity;
            for (Mob mob : MobBuilder.of(type, x -> {
                x.amount = finalAmount;
                if (finalRarity != null) {
                    x.rarity = finalRarity;
                }
            }).summonMobs(world, pos)) {
                if (!isBoss) continue;
                Load.Unit((Entity)mob).setupRandomBoss();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

