/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.maps.processors.mob;

import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.maps.generator.ChunkProcessData;
import com.robertx22.mine_and_slash.maps.processors.DataProcessor;
import com.robertx22.mine_and_slash.maps.processors.helpers.MobBuilder;
import com.robertx22.mine_and_slash.maps.spawned_map_mobs.SpawnedMob;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;

public class BossProcessor
extends DataProcessor {
    public BossProcessor() {
        super("boss_mob");
        this.detectIds.add("boss");
    }

    @Override
    public boolean canSpawnLeagueMechanic() {
        return false;
    }

    @Override
    public void processImplementation(String key, BlockPos pos, Level world, ChunkProcessData data) {
        MapData map = Load.mapAt(world, pos);
        EntityType type = SpawnedMob.random(map).getType();
        for (Mob en : MobBuilder.of(type, x -> {
            x.rarity = (GearRarity)ExileDB.GearRarities().get("mythic");
        }).summonMobs(world, pos)) {
            Load.Unit((Entity)en).setupRandomBoss();
        }
    }
}

