/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.maps.processors.misc;

import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.maps.generator.ChunkProcessData;
import com.robertx22.mine_and_slash.maps.processors.DataProcessor;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class RemoveAllBesidesOneProcessor
extends DataProcessor {
    public RemoveAllBesidesOneProcessor() {
        super("remove_all_besides_one", DataProcessor.Type.CONTAINS);
    }

    @Override
    public boolean canSpawnLeagueMechanic() {
        return false;
    }

    @Override
    public void processImplementation(String key, BlockPos pos, Level world, ChunkProcessData data) {
        try {
            String[] parts = key.split(":");
            String blockID = parts[1];
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockID));
            ArrayList<BlockPos> list = new ArrayList<BlockPos>();
            Function<BlockPos, Boolean> function = null;
            if (blockID.equals("button")) {
                function = x -> {
                    BlockState state = world.m_8055_(x);
                    if (state.m_60734_() instanceof ButtonBlock) {
                        return true;
                    }
                    return false;
                };
            }
            for (BlockPos blockPos : data.getBlockPosList()) {
                if (!function.apply(blockPos).booleanValue()) continue;
                list.add(blockPos);
            }
            if (!list.isEmpty()) {
                list.remove(RandomUtils.RandomRange((int)0, (int)(list.size() - 1)));
                list.forEach(x -> world.m_7731_(x, Blocks.f_50016_.m_49966_(), 2));
            } else {
                ExileLog.get().warn("Didn't find any correct blocks?", new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

