/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.maps.processors.helpers;

import com.robertx22.library_of_exile.utils.geometry.MyPosition;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.event_hooks.entity.OnMobSpawn;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.mmorpg.ModErrors;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class MobBuilder {
    private EntityType type;
    public GearRarity rarity;
    public int amount = 1;

    private MobBuilder() {
    }

    public static MobBuilder of(EntityType type, Consumer<MobBuilder> co) {
        MobBuilder b = new MobBuilder();
        b.type = type;
        co.accept(b);
        return b;
    }

    public <T extends Mob> List<T> summonMobs(Level world, BlockPos p) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < this.amount; ++i) {
            T mob = this.summon(this.type, world, p);
            list.add(mob);
        }
        return list;
    }

    private <T extends Mob> T summon(EntityType<T> type, Level world, BlockPos p) {
        MyPosition vec = new MyPosition(p);
        Mob mob = (Mob)type.m_20615_(world);
        mob.m_6518_((ServerLevelAccessor)world, world.m_6436_(p), MobSpawnType.REINFORCEMENT, null, null);
        mob.m_6034_(vec.m_7096_(), vec.m_7098_(), vec.m_7094_());
        OnMobSpawn.setupNewMobOnSpawn((LivingEntity)mob);
        if (this.rarity != null) {
            Load.Unit((Entity)mob).setRarity(this.rarity.GUID());
        }
        Load.Unit((Entity)mob).isCorrectlySpawnedMapMob = true;
        try {
            if (WorldUtils.isMapWorldClass(world)) {
                MapData map = Load.mapAt(world, p);
                Load.Unit((Entity)mob).mapUUID = map.map.uuid;
            }
        }
        catch (Exception e) {
            ModErrors.print(e);
        }
        world.m_7967_((Entity)mob);
        return (T)mob;
    }
}

