/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.maps.processors;

import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.maps.generator.ChunkProcessData;
import com.robertx22.mine_and_slash.saveclasses.PointData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;

public abstract class DataProcessor {
    Type type;
    public List<String> detectIds = new ArrayList<String>();

    public DataProcessor(String detectIds) {
        this.detectIds.add(detectIds);
        this.type = Type.EQUALS;
    }

    public DataProcessor(String detectIds, Type type) {
        this.detectIds.add(detectIds);
        this.type = type;
    }

    public static String getData(BlockEntity be) {
        if (be instanceof StructureBlockEntity) {
            StructureBlockEntity struc = (StructureBlockEntity)be;
            CompoundTag nbt = struc.m_187482_();
            return nbt.m_128461_("metadata");
        }
        if (be instanceof CommandBlockEntity) {
            CommandBlockEntity cb = (CommandBlockEntity)be;
            return cb.m_59141_().m_45438_();
        }
        return "";
    }

    public abstract boolean canSpawnLeagueMechanic();

    public final boolean process(String key, BlockPos pos, Level world, ChunkProcessData chunkData) {
        MapData map = Load.mapAt(world, pos);
        if (this.type == Type.EQUALS && this.detectIds.contains(key)) {
            this.processImplementation(key, pos, world, chunkData);
            this.trySpawnLeagueMechanicIfCan(map, world, pos);
            return true;
        }
        if (this.type == Type.CONTAINS) {
            if (this.detectIds.stream().anyMatch(key::contains)) {
                this.processImplementation(key, pos, world, chunkData);
                this.trySpawnLeagueMechanicIfCan(map, world, pos);
                return true;
            }
        }
        return false;
    }

    public void trySpawnLeagueMechanicIfCan(MapData map, Level world, BlockPos pos) {
        if (this.canSpawnLeagueMechanic()) {
            float chance = map.leagues.calcSpawnChance(pos);
            if (RandomUtils.roll((float)chance)) {
                map.spawnRandomLeagueMechanic(world, pos);
            }
            ChunkPos cp = new ChunkPos(pos);
            PointData point = new PointData(cp.f_45578_, cp.f_45579_);
            map.leagues.mechsChunks.add(point);
        }
    }

    public abstract void processImplementation(String var1, BlockPos var2, Level var3, ChunkProcessData var4);

    public static enum Type {
        EQUALS,
        CONTAINS;

    }
}

