/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.maps.generator;

import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.registry.IWeighted;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.maps.DungeonRoom;
import com.robertx22.mine_and_slash.maps.dungeon_reg.Dungeon;
import com.robertx22.mine_and_slash.maps.generator.DungeonBuilder;
import com.robertx22.mine_and_slash.maps.generator.RoomRotation;
import com.robertx22.mine_and_slash.maps.generator.RoomSide;
import com.robertx22.mine_and_slash.maps.generator.RoomSides;
import com.robertx22.mine_and_slash.maps.generator.UnbuiltRoom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.Rotation;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RoomType implements IWeighted
{
    FOUR_WAY("four_way"){

        @Override
        public List<RoomRotation> getRotations() {
            ArrayList<RoomRotation> all = new ArrayList<RoomRotation>();
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.DOOR, RoomSide.DOOR, RoomSide.DOOR), Rotation.NONE));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.DOOR, RoomSide.DOOR, RoomSide.DOOR), Rotation.NONE));
            return all;
        }
    }
    ,
    STRAIGHT_HALLWAY("straight_hallway"){

        @Override
        public List<RoomRotation> getRotations() {
            ArrayList<RoomRotation> all = new ArrayList<RoomRotation>();
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.BLOCKED), Rotation.NONE));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.DOOR), Rotation.CLOCKWISE_90));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.BLOCKED), Rotation.CLOCKWISE_180));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.DOOR), Rotation.COUNTERCLOCKWISE_90));
            return all;
        }
    }
    ,
    CURVED_HALLWAY("curved_hallway"){

        @Override
        public List<RoomRotation> getRotations() {
            ArrayList<RoomRotation> all = new ArrayList<RoomRotation>();
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.DOOR), Rotation.NONE));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.DOOR, RoomSide.BLOCKED), Rotation.CLOCKWISE_90));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.BLOCKED), Rotation.CLOCKWISE_180));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.DOOR), Rotation.COUNTERCLOCKWISE_90));
            return all;
        }
    }
    ,
    TRIPLE_HALLWAY("triple_hallway"){

        @Override
        public List<RoomRotation> getRotations() {
            ArrayList<RoomRotation> all = new ArrayList<RoomRotation>();
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.DOOR, RoomSide.DOOR), Rotation.NONE));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.DOOR, RoomSide.DOOR, RoomSide.BLOCKED), Rotation.CLOCKWISE_90));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.DOOR), Rotation.CLOCKWISE_180));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.DOOR), Rotation.COUNTERCLOCKWISE_90));
            return all;
        }
    }
    ,
    END("end"){

        @Override
        public List<RoomRotation> getRotations() {
            ArrayList<RoomRotation> all = new ArrayList<RoomRotation>();
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.BLOCKED), Rotation.NONE));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.DOOR), Rotation.CLOCKWISE_90));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.BLOCKED), Rotation.CLOCKWISE_180));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.BLOCKED), Rotation.COUNTERCLOCKWISE_90));
            return all;
        }
    }
    ,
    ENTRANCE("entrance"){

        @Override
        public List<RoomRotation> getRotations() {
            ArrayList<RoomRotation> all = new ArrayList<RoomRotation>();
            all.add(new RoomRotation(this, new RoomSides(RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.BLOCKED), Rotation.NONE));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.DOOR), Rotation.CLOCKWISE_90));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.BLOCKED, RoomSide.BLOCKED), Rotation.CLOCKWISE_180));
            all.add(new RoomRotation(this, new RoomSides(RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.DOOR, RoomSide.BLOCKED), Rotation.COUNTERCLOCKWISE_90));
            return all;
        }
    };

    public RoomSides sides;
    public String id;

    private RoomType(String id) {
        this.id = id;
    }

    public abstract List<RoomRotation> getRotations();

    public DungeonRoom getRandomRoom(Dungeon dun, DungeonBuilder builder) {
        List<DungeonRoom> possible;
        Dungeon tryGroup;
        Dungeon d = dun;
        if (dun.allowsOtherTilesets() && RandomUtils.roll((double)dun.other_tileset_chance, (Random)builder.rand) && (tryGroup = (Dungeon)RandomUtils.weightedRandom(dun.getPossibleOtherTilesets(), (double)builder.rand.nextDouble())).hasRoomFor(this)) {
            d = tryGroup;
        }
        if ((possible = d.getRoomsOfType(this)).isEmpty()) {
            Dungeon fallback = dun.getFallbackGroup(builder.rand);
            possible.addAll(fallback.getRoomsOfType(this));
        }
        if (possible.isEmpty()) {
            ExileLog.get().warn("No possible rooms?", new Object[0]);
        }
        if (builder.builtDungeon.bossRooms >= builder.maxBossRooms) {
            possible = RoomType.tryFilter(possible, r -> !r.isBoss);
        }
        return (DungeonRoom)RandomUtils.weightedRandom(possible, (double)builder.rand.nextDouble());
    }

    public static List<DungeonRoom> tryFilter(List<DungeonRoom> rooms, Predicate<DungeonRoom> pred) {
        List<DungeonRoom> filtered = rooms.stream().filter(pred).collect(Collectors.toList());
        if (filtered.isEmpty()) {
            return rooms;
        }
        return filtered;
    }

    public List<RoomRotation> getPossibleFor(UnbuiltRoom room) {
        return this.getRotations().stream().filter(x -> x.sides.matches(room.sides)).collect(Collectors.toList());
    }

    public int Weight() {
        return 1000;
    }
}

