/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.maps.generator;

import com.robertx22.mine_and_slash.maps.generator.RoomSide;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;

public class RoomSides {
    public RoomSide SOUTH;
    public RoomSide NORTH;
    public RoomSide EAST;
    public RoomSide WEST;

    public List<Direction> getDoorSides() {
        ArrayList<Direction> list = new ArrayList<Direction>();
        if (this.SOUTH == RoomSide.DOOR) {
            list.add(Direction.SOUTH);
        }
        if (this.NORTH == RoomSide.DOOR) {
            list.add(Direction.NORTH);
        }
        if (this.EAST == RoomSide.DOOR) {
            list.add(Direction.EAST);
        }
        if (this.WEST == RoomSide.DOOR) {
            list.add(Direction.WEST);
        }
        return list;
    }

    public RoomSides(RoomSide SOUTH, RoomSide NORTH, RoomSide EAST, RoomSide WEST) {
        this.SOUTH = SOUTH;
        this.NORTH = NORTH;
        this.EAST = EAST;
        this.WEST = WEST;
    }

    public RoomSide getSideOfDirection(Direction dir) {
        if (dir == Direction.NORTH) {
            return this.NORTH;
        }
        if (dir == Direction.SOUTH) {
            return this.SOUTH;
        }
        if (dir == Direction.EAST) {
            return this.EAST;
        }
        if (dir == Direction.WEST) {
            return this.WEST;
        }
        return null;
    }

    public boolean matches(RoomSides data) {
        return this.SOUTH.canBeLinked(data.SOUTH) && this.NORTH.canBeLinked(data.NORTH) && this.EAST.canBeLinked(data.EAST) && this.WEST.canBeLinked(data.WEST);
    }

    public String getFirstLineDebug() {
        Object s = "";
        s = (String)s + "X;" + this.NORTH.debugString + ";X";
        return s;
    }

    public String getSecondString() {
        Object s = "";
        s = (String)s + this.WEST.debugString + ";O;" + this.EAST.debugString;
        return s;
    }

    public String getThirdString() {
        Object s = "";
        s = (String)s + "X;" + this.SOUTH.debugString + ";X";
        return s;
    }

    public String getDebugString() {
        Object s = "";
        s = (String)s + "X" + this.NORTH.debugString + "X\n";
        s = (String)s + this.WEST.debugString + "O" + this.EAST.debugString + "\n";
        s = (String)s + "X" + this.SOUTH.debugString + "X\n";
        return s;
    }
}

