/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.maps.generator;

import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.maps.DungeonRoom;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.maps.dungeon_reg.Dungeon;
import com.robertx22.mine_and_slash.maps.generator.BuiltDungeon;
import com.robertx22.mine_and_slash.maps.generator.BuiltRoom;
import com.robertx22.mine_and_slash.maps.generator.RoomRotation;
import com.robertx22.mine_and_slash.maps.generator.RoomType;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;

public class DungeonBuilder {
    public Dungeon dungeon;
    public BuiltDungeon builtDungeon;
    public final Random rand;
    public int size;
    public boolean isTesting = false;
    public int maxBossRooms = 1;

    public static Random createRandom(long worldSeed, ChunkPos cpos) {
        int chunkX = MapData.getStartChunk((BlockPos)cpos.m_151394_((int)55)).f_45578_;
        int chunkZ = MapData.getStartChunk((BlockPos)cpos.m_151394_((int)55)).f_45579_;
        long newSeed = worldSeed + (long)(chunkX * chunkX * 4987142) + (long)(chunkX * 5947611) + (long)(chunkZ * chunkZ) * 4392871L + (long)(chunkZ * 389711) ^ worldSeed;
        return new Random(newSeed);
    }

    public DungeonBuilder(long worldSeed, ChunkPos cpos) {
        this.rand = DungeonBuilder.createRandom(worldSeed, cpos);
        this.dungeon = (Dungeon)RandomUtils.weightedRandom((Collection)ExileDB.Dungeons().getFilterWrapped((Predicate<Dungeon>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$0(com.robertx22.mine_and_slash.maps.dungeon_reg.Dungeon ), (Lcom/robertx22/mine_and_slash/maps/dungeon_reg/Dungeon;)Z)()).list, (double)this.rand.nextDouble());
        this.size = RandomUtils.RandomRange((int)((Integer)ServerContainer.get().MIN_MAP_ROOMS.get()), (int)((Integer)ServerContainer.get().MAX_MAP_ROOMS.get()), (Random)this.rand);
        if (RandomUtils.roll((double)5.0, (Random)this.rand)) {
            ++this.maxBossRooms;
        }
    }

    public void build() {
        this.builtDungeon = new BuiltDungeon(this.size, this);
        this.builtDungeon.setupBarriers();
        this.setupEntrance();
        this.builtDungeon.fillWithBarriers();
    }

    public RoomRotation random(List<RoomRotation> list) {
        return (RoomRotation)RandomUtils.weightedRandom(list, (double)this.rand.nextDouble());
    }

    private void setupEntrance() {
        DungeonRoom entranceRoom = RoomType.ENTRANCE.getRandomRoom(this.dungeon, this);
        ArrayList<RoomRotation> possible = new ArrayList<RoomRotation>();
        possible.addAll(RoomType.ENTRANCE.getRotations());
        RoomRotation rotation = this.random(possible);
        BuiltRoom entrance = new BuiltRoom(this.dungeon, rotation, entranceRoom);
        int mid = this.builtDungeon.getMiddle();
        this.builtDungeon.addRoom(mid, mid, entrance);
    }

    private static /* synthetic */ boolean lambda$new$0(Dungeon x) {
        return x.can_be_main;
    }
}

