/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.maps.generator;

import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.maps.DungeonRoom;
import com.robertx22.mine_and_slash.maps.dungeon_reg.Dungeon;
import com.robertx22.mine_and_slash.maps.generator.RoomRotation;
import com.robertx22.mine_and_slash.maps.generator.RoomSide;
import com.robertx22.mine_and_slash.maps.generator.RoomSides;
import com.robertx22.mine_and_slash.maps.generator.RoomType;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Rotation;

public class BuiltRoom {
    private String dungeon;
    public RoomRotation data;
    public DungeonRoom room;

    public BuiltRoom(Dungeon dun, RoomRotation data, DungeonRoom room) {
        this.data = data;
        this.room = room;
        this.dungeon = dun.GUID();
    }

    public Dungeon getDungeon() {
        return (Dungeon)ExileDB.Dungeons().get(this.dungeon);
    }

    public ResourceLocation getStructure() {
        return this.room.loc;
    }

    public static BuiltRoom getBarrier() {
        DungeonRoom barrier = new DungeonRoom(Dungeon.SERIALIZER, "", RoomType.END);
        barrier.isBarrier = true;
        barrier.loc = new ResourceLocation("mmorpg", "dun/barrier");
        RoomRotation rot = new RoomRotation(RoomType.END, new RoomSides(RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.BLOCKED, RoomSide.BLOCKED), Rotation.NONE);
        BuiltRoom built = new BuiltRoom(Dungeon.SERIALIZER, rot, barrier);
        return built;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuiltRoom builtRoom = (BuiltRoom)o;
        return this.hashCode() == builtRoom.hashCode();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.room.toString(), this.data.rotation, this.data.type});
    }
}

