/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.maps.feature;

import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.maps.generator.BuiltRoom;
import com.robertx22.mine_and_slash.maps.generator.DungeonBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class DungeonFeature {
    public static boolean place(MapData mapData, LevelAccessor level, RandomSource rand, BlockPos pos) {
        return DungeonFeature.generateStructure(mapData, level, new ChunkPos(pos), rand);
    }

    private static boolean generateStructure(MapData mapData, LevelAccessor world, ChunkPos cpos, RandomSource random) {
        BuiltRoom room;
        DungeonBuilder builder = new DungeonBuilder(0L, cpos);
        builder.build();
        if (!builder.builtDungeon.hasRoomForChunk(cpos)) {
            return false;
        }
        BlockPos bpos = cpos.m_151394_(50);
        ChunkPos start = MapData.getStartChunk(bpos);
        if (cpos.equals((Object)start)) {
            // empty if block
        }
        if ((room = builder.builtDungeon.getRoomForChunk(cpos)) == null) {
            return false;
        }
        if (!room.room.isBarrier) {
            ++mapData.leagues.totalGenDungeonChunks;
        }
        StructureTemplate template = (StructureTemplate)world.m_7654_().m_236738_().m_230407_(room.getStructure()).get();
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74379_(room.data.rotation).m_74392_(false);
        settings.m_74381_(settings.m_74409_());
        BlockPos position = cpos.m_151384_(0, 50, 0);
        if (template == null) {
            ExileLog.get().warn("FATAL ERROR: Structure does not exist (" + room.getStructure() + ")", new Object[0]);
            return false;
        }
        if (room.data.rotation == Rotation.COUNTERCLOCKWISE_90) {
            settings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
            position = position.m_7918_(0, 0, template.m_163801_().m_123343_() - 1);
        } else if (room.data.rotation == Rotation.CLOCKWISE_90) {
            settings.m_74379_(Rotation.CLOCKWISE_90);
            position = position.m_7918_(template.m_163801_().m_123341_() - 1, 0, 0);
        } else if (room.data.rotation == Rotation.CLOCKWISE_180) {
            settings.m_74379_(Rotation.CLOCKWISE_180);
            position = position.m_7918_(template.m_163801_().m_123341_() - 1, 0, template.m_163801_().m_123343_() - 1);
        } else {
            settings.m_74379_(Rotation.NONE);
        }
        template.m_230328_((ServerLevelAccessor)world, position, position, settings, random, 2);
        return true;
    }
}

