/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.maps.dungeon_reg;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.maps.DungeonRoom;
import com.robertx22.mine_and_slash.maps.generator.RoomType;
import com.robertx22.mine_and_slash.maps.room_adders.BaseRoomAdder;
import com.robertx22.mine_and_slash.tags.TagList;
import com.robertx22.mine_and_slash.tags.all.DungeonTags;
import com.robertx22.mine_and_slash.tags.imp.DungeonTag;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

public class Dungeon
implements IAutoGson<Dungeon>,
JsonExileRegistry<Dungeon>,
IAutoLocName {
    public static Dungeon SERIALIZER = new Dungeon();
    public String id = "";
    public int weight = 1000;
    public String name = "";
    public boolean can_be_main = true;
    public TagList<DungeonTag> tags = new TagList<DungeonTag>(Arrays.asList(DungeonTags.DEFAULT));
    public List<String> entrances = new ArrayList<String>();
    public List<String> four_ways = new ArrayList<String>();
    public List<String> straight_hallways = new ArrayList<String>();
    public List<String> curved_hallways = new ArrayList<String>();
    public List<String> triple_hallway = new ArrayList<String>();
    public List<String> ends = new ArrayList<String>();
    public List<String> other_tileset = new ArrayList<String>();
    public float other_tileset_chance = 5.0f;
    private transient List<DungeonRoom> rooms = new ArrayList<DungeonRoom>();

    public boolean allowsOtherTilesets() {
        return !this.other_tileset.isEmpty();
    }

    public List<Dungeon> getPossibleOtherTilesets() {
        List<Dungeon> list = this.other_tileset.stream().map(x -> (Dungeon)ExileDB.Dungeons().get(x)).collect(Collectors.toList());
        return list;
    }

    public Dungeon getFallbackGroup(Random rand) {
        if (!this.allowsOtherTilesets()) {
            return (Dungeon)ExileDB.Dungeons().get("misc");
        }
        return (Dungeon)RandomUtils.weightedRandom(this.getPossibleOtherTilesets(), (double)rand.nextDouble());
    }

    public List<DungeonRoom> getRooms() {
        if (this.rooms.isEmpty()) {
            this.addRooms(RoomType.ENTRANCE, this.entrances);
            this.addRooms(RoomType.FOUR_WAY, this.four_ways);
            this.addRooms(RoomType.STRAIGHT_HALLWAY, this.straight_hallways);
            this.addRooms(RoomType.CURVED_HALLWAY, this.curved_hallways);
            this.addRooms(RoomType.TRIPLE_HALLWAY, this.triple_hallway);
            this.addRooms(RoomType.END, this.ends);
        }
        return this.rooms;
    }

    public List<DungeonRoom> getRoomsOfType(RoomType type) {
        return this.getRooms().stream().filter(x -> x.type.equals((Object)type)).collect(Collectors.toList());
    }

    public List<String> getRoomList(RoomType type) {
        if (type == RoomType.END) {
            return this.ends;
        }
        if (type == RoomType.ENTRANCE) {
            return this.entrances;
        }
        if (type == RoomType.FOUR_WAY) {
            return this.four_ways;
        }
        if (type == RoomType.CURVED_HALLWAY) {
            return this.curved_hallways;
        }
        if (type == RoomType.STRAIGHT_HALLWAY) {
            return this.straight_hallways;
        }
        if (type == RoomType.TRIPLE_HALLWAY) {
            return this.triple_hallway;
        }
        return Arrays.asList(new String[0]);
    }

    private void addRooms(RoomType type, List<String> list) {
        for (String room : list) {
            DungeonRoom b = new DungeonRoom(this, room, type);
            this.rooms.add(b);
        }
    }

    public final boolean hasRoomFor(RoomType type) {
        return this.getRooms().stream().anyMatch(x -> x.type.equals((Object)type));
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.DUNGEON;
    }

    public Class<Dungeon> getClassForSerialization() {
        return Dungeon.class;
    }

    public String GUID() {
        return this.id;
    }

    public int Weight() {
        return this.weight;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.DUNGEON;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.mmorpg." + this.GUID();
    }

    @Override
    public String locNameForLangFile() {
        return this.name;
    }

    public static class Builder {
        Dungeon dungeon = new Dungeon();

        public static Builder of(String id, String name, BaseRoomAdder adder) {
            Builder b = new Builder();
            b.dungeon.id = id;
            b.dungeon.name = name;
            adder.addRoomsToDungeon(b.dungeon);
            return b;
        }

        public Builder weight(int w) {
            this.dungeon.weight = w;
            return this;
        }

        public Builder tags(DungeonTag ... tags) {
            this.dungeon.tags.addAll(Arrays.asList(tags));
            return this;
        }

        public Builder setIsOnlyAsAdditionalRooms() {
            this.dungeon.can_be_main = false;
            return this;
        }

        public Dungeon build() {
            this.dungeon.addToSerializables();
            return this.dungeon;
        }
    }
}

