/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.maps;

import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.mine_and_slash.capability.chunk.ChunkData;
import com.robertx22.mine_and_slash.capability.world.WorldData;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.database.data.league.LeagueMechanic;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.maps.feature.DungeonFeature;
import com.robertx22.mine_and_slash.maps.generator.BuiltRoom;
import com.robertx22.mine_and_slash.maps.generator.ChunkProcessData;
import com.robertx22.mine_and_slash.maps.generator.DungeonBuilder;
import com.robertx22.mine_and_slash.maps.processors.DataProcessor;
import com.robertx22.mine_and_slash.maps.processors.DataProcessors;
import com.robertx22.mine_and_slash.maps.processors.league.LeagueSpawnPos;
import com.robertx22.mine_and_slash.maps.spawned_map_mobs.SpawnedMobList;
import com.robertx22.mine_and_slash.tags.imp.DungeonTag;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;

public class ProcessChunkBlocks {
    private static void logRoomForPos(Level world, BlockPos pos) {
        try {
            ChunkPos cpos = new ChunkPos(pos);
            DungeonBuilder builder = new DungeonBuilder(0L, cpos);
            builder.build();
            BuiltRoom room = builder.builtDungeon.getRoomForChunk(cpos);
            ExileLog.get().log("Room affected: " + room.getStructure().toString(), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void process(ServerLevel level, BlockPos pos) {
        try {
            if (level.f_46443_) {
                return;
            }
            if (WorldUtils.isMapWorldClass((Level)level)) {
                BuiltRoom room;
                ChunkData chunkdata;
                LevelChunk chunk;
                LevelChunk c;
                int z;
                int x2;
                WorldData mapdata = Load.worldData((Level)level);
                ChunkPos start = new ChunkPos(pos);
                Optional<MapData> opt = mapdata.map.getMap(start);
                if (!opt.isPresent()) {
                    return;
                }
                ArrayList<ChunkPos> terrainChunks = new ArrayList<ChunkPos>();
                terrainChunks.add(start);
                ArrayList<ChunkPos> mobChunks = new ArrayList<ChunkPos>();
                mobChunks.add(start);
                int terrain = (Integer)ServerContainer.get().MAP_GEN_TERRAIN_RADIUS.get();
                int mob = (Integer)ServerContainer.get().MAP_GEN_MOB_RADIUS.get();
                for (x2 = -terrain; x2 < terrain; ++x2) {
                    for (z = -terrain; z < terrain; ++z) {
                        terrainChunks.add(new ChunkPos(start.f_45578_ + x2, start.f_45579_ + z));
                    }
                }
                for (x2 = -mob; x2 < mob; ++x2) {
                    for (z = -mob; z < mob; ++z) {
                        mobChunks.add(new ChunkPos(start.f_45578_ + x2, start.f_45579_ + z));
                    }
                }
                int gened = 0;
                int maxtogen = 3;
                DungeonBuilder builder = new DungeonBuilder(0L, start);
                builder.build();
                MapData map = Load.mapAt((Level)level, pos);
                if (map == null || map.map == null) {
                    return;
                }
                map.dungeonid = builder.dungeon.GUID();
                if (map.mobs.isEmpty()) {
                    SpawnedMobList mobs = (SpawnedMobList)ExileDB.MapMobs().getFilterWrapped(x -> builder.dungeon.tags.containsAny(x.possible_dungeon_tags.getTags(DungeonTag.SERIALIZER))).random();
                    map.mobs = mobs.GUID();
                }
                for (ChunkPos cpos : terrainChunks) {
                    if (!level.m_7232_(cpos.f_45578_, cpos.f_45579_) || !((c = level.m_6325_(cpos.f_45578_, cpos.f_45579_)) instanceof LevelChunk)) continue;
                    chunk = c;
                    chunkdata = Load.chunkData(chunk);
                    if (chunkdata.generatedTerrain) continue;
                    chunkdata.generatedTerrain = true;
                    DungeonFeature.place(opt.get(), (LevelAccessor)level, level.m_213780_(), cpos.m_151384_(0, 0, 0));
                    room = builder.builtDungeon.getRoomForChunk(cpos);
                    Random ran = DungeonBuilder.createRandom(0L, cpos);
                    for (LeagueMechanic mech : opt.get().leagues.getLeagueMechanics()) {
                        mech.getStructure(map.map).tryGenerate(level, cpos, ran);
                        ProcessChunkBlocks.leagueSpawn(level, chunk, room);
                    }
                    if (++gened < maxtogen) continue;
                    return;
                }
                for (ChunkPos cpos : mobChunks) {
                    if (!level.m_7232_(cpos.f_45578_, cpos.f_45579_) || !((c = level.m_6325_(cpos.f_45578_, cpos.f_45579_)) instanceof LevelChunk)) continue;
                    chunk = c;
                    chunkdata = Load.chunkData(chunk);
                    if (chunkdata.generatedMobs) continue;
                    chunkdata.generatedMobs = true;
                    room = builder.builtDungeon.getRoomForChunk(cpos);
                    ProcessChunkBlocks.generateData(level, chunk, room);
                    ++map.leagues.processedChunks;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void generateData(ServerLevel level, LevelChunk chunk, BuiltRoom room) {
        ChunkProcessData data = new ChunkProcessData((ChunkAccess)chunk, room);
        for (BlockPos tilePos : chunk.m_5928_()) {
            BlockEntity tile = level.m_7702_(tilePos);
            String text = DataProcessor.getData(tile);
            if (text.isEmpty()) continue;
            boolean any = false;
            for (DataProcessor processor : DataProcessors.getAll()) {
                boolean did = processor.process(text, tilePos, (Level)level, data);
                if (!did) continue;
                any = true;
            }
            if (!any) {
                // empty if block
            }
            if (any) {
                if (level.m_8055_(tilePos).m_60734_() != Blocks.f_50677_ && level.m_8055_(tilePos).m_60734_() != Blocks.f_50272_) continue;
                level.m_46747_(tilePos);
                level.m_7731_(tilePos, Blocks.f_50016_.m_49966_(), 3);
                continue;
            }
            ExileLog.get().warn("Data block with tag: " + text + " matched no processors! " + tilePos.toString(), new Object[0]);
            ProcessChunkBlocks.logRoomForPos((Level)level, tilePos);
        }
    }

    static void leagueSpawn(ServerLevel level, LevelChunk chunk, BuiltRoom room) {
        ChunkProcessData data = new ChunkProcessData((ChunkAccess)chunk, room);
        for (BlockPos tilePos : chunk.m_5928_()) {
            BlockEntity tile = level.m_7702_(tilePos);
            String text = DataProcessor.getData(tile);
            if (text.isEmpty()) continue;
            boolean any = false;
            LeagueSpawnPos processor = new LeagueSpawnPos();
            boolean did = processor.process(text, tilePos, (Level)level, data);
            if (did) {
                any = true;
            }
            if (!any || level.m_8055_(tilePos).m_60734_() != Blocks.f_50677_ && level.m_8055_(tilePos).m_60734_() != Blocks.f_50272_) continue;
            level.m_7731_(tilePos, Blocks.f_50016_.m_49966_(), 3);
            level.m_46747_(tilePos);
        }
    }
}

