/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.maps;

import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.database.data.league.LeagueMechanic;
import com.robertx22.mine_and_slash.database.data.league.LeagueMechanics;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.maps.LeagueData;
import com.robertx22.mine_and_slash.maps.MapItemData;
import com.robertx22.mine_and_slash.saveclasses.PointData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;

public class MapLeaguesData {
    HashMap<String, LeagueData> map = new HashMap();
    public int totalGenDungeonChunks = 0;
    public int processedChunks = 0;
    public Set<PointData> mechsChunks = new HashSet<PointData>();

    public float calcSpawnChance(BlockPos pos) {
        ChunkPos cp = new ChunkPos(pos);
        PointData point = new PointData(cp.f_45578_, cp.f_45579_);
        if (this.mechsChunks.contains(point)) {
            return 0.0f;
        }
        int chunksLeft = this.totalGenDungeonChunks - this.processedChunks;
        int remaining = this.getTotalSpawnsRemainingFromAllLeagues();
        if (chunksLeft < remaining) {
            return 100.0f;
        }
        float chance = (float)remaining / (float)chunksLeft * 100.0f;
        return chance;
    }

    public int getTotalSpawnsRemainingFromAllLeagues() {
        return this.map.values().stream().mapToInt(x -> x.remainingSpawns).sum();
    }

    public List<LeagueMechanic> getLeagueMechanics() {
        return this.map.keySet().stream().map(x -> (LeagueMechanic)ExileDB.LeagueMechanics().get(x)).collect(Collectors.toList());
    }

    public void setupOnMapStart(MapItemData map, Player p) {
        for (LeagueMechanic m : ExileDB.LeagueMechanics().getList()) {
            if (!(m.getBaseSpawnChance() > 0.0f) || !RandomUtils.roll((float)m.getBaseSpawnChance())) continue;
            LeagueData data = new LeagueData();
            m.onMapStartSetupBase(map, data);
            m.onMapStartSetup(data);
            this.map.put(m.GUID(), data);
        }
        if (map.isUber()) {
            LeagueData data = new LeagueData();
            LeagueMechanics.UBER.onMapStartSetupBase(map, data);
            LeagueMechanics.UBER.onMapStartSetup(data);
            this.map.put(LeagueMechanics.UBER_ID, data);
        }
    }

    public LeagueData get(LeagueMechanic m) {
        return this.map.getOrDefault(m.GUID(), LeagueData.EMPTY);
    }
}

