/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.maps;

import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.library_of_exile.utils.TeleportUtils;
import com.robertx22.mine_and_slash.database.data.league.LeagueMechanic;
import com.robertx22.mine_and_slash.database.data.league.LeagueMechanics;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.maps.MapItemData;
import com.robertx22.mine_and_slash.maps.MapLeaguesData;
import com.robertx22.mine_and_slash.maps.MapsData;
import com.robertx22.mine_and_slash.maps.spawned_map_mobs.SpawnedMobList;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.border.WorldBorder;

public class MapData {
    public MapItemData map = new MapItemData();
    public MapLeaguesData leagues = new MapLeaguesData();
    private HashMap<String, Integer> lives = new HashMap();
    public String dungeonid = "";
    public String mobs = "";
    public String playerUuid = "";
    public int chunkX = 0;
    public int chunkZ = 0;
    public static int DUNGEON_LENGTH = 30;

    public SpawnedMobList getMobSpawns() {
        return (SpawnedMobList)ExileDB.MapMobs().get(this.mobs);
    }

    public int getLives(Player p) {
        int cur = this.lives.getOrDefault(p.m_20149_(), this.map.getRarity().map_lives);
        return cur;
    }

    public void reduceLives(Player p) {
        int cur = this.getLives(p) - 1;
        this.lives.put(p.m_20149_(), cur);
    }

    public static MapData newMap(Player p, MapItemData map, MapsData maps) {
        Load.player((Player)p).prophecy.affixesTaken.clear();
        maps.deleteOldMap(p);
        MapData data = new MapData();
        data.playerUuid = p.m_20149_();
        data.map = map;
        ChunkPos cp = data.randomFree(p.m_9236_(), maps);
        data.chunkX = cp.f_45578_;
        data.chunkZ = cp.f_45579_;
        data.leagues.setupOnMapStart(map, p);
        return data;
    }

    public void spawnRandomLeagueMechanic(Level level, BlockPos pos) {
        List list;
        if (LeagueMechanics.NONE.getStructure(this.map).isInsideLeague((ServerLevel)level, pos) && (list = this.leagues.getLeagueMechanics().stream().filter(x -> this.leagues.get((LeagueMechanic)x).remainingSpawns > 0).collect(Collectors.toList())).size() > 0) {
            LeagueMechanic league = (LeagueMechanic)RandomUtils.randomFromList(list);
            league.spawnMechanicInMap((ServerLevel)level, pos);
            --this.leagues.get((LeagueMechanic)league).remainingSpawns;
        }
    }

    public void teleportToMap(Player p) {
        if (p.m_9236_().f_46443_) {
            return;
        }
        Load.player((Player)p).map.sendMapTpMsg = true;
        Load.player((Player)p).map.tpbackdim = p.m_9236_().m_46472_().m_135782_().toString();
        Load.player((Player)p).map.tp_back_pos = p.m_20183_().m_121878_();
        BlockPos pos = MapData.getDungeonStartTeleportPos(new ChunkPos(this.chunkX, this.chunkZ));
        ServerLevel world = p.m_9236_().m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)WorldUtils.DUNGEON_DIM_ID));
        world.m_7731_(new BlockPos(pos.m_123341_(), 54, pos.m_123343_()), Blocks.f_50752_.m_49966_(), 2);
        TeleportUtils.teleport((ServerPlayer)((ServerPlayer)p), (BlockPos)pos, (ResourceLocation)WorldUtils.DUNGEON_DIM_ID);
    }

    public static BlockPos getDungeonStartTeleportPos(ChunkPos pos) {
        BlockPos p = MapData.getStartChunk(pos).m_151384_(0, 0, 0);
        p = new BlockPos(p.m_123341_() + 8, 57, p.m_123343_() + 8);
        return p;
    }

    private ChunkPos randomFree(Level level, MapsData maps) {
        ChunkPos pos = null;
        int tries = 0;
        WorldBorder border = level.m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)WorldUtils.DUNGEON_DIM_ID)).m_6857_();
        int max = (int)(border.m_61959_() / 16.0 / 2.0);
        max = MathHelper.clamp(max, 0, 149999);
        while (pos == null || maps.getMap(pos).isPresent()) {
            if (tries > 200) {
                ExileLog.get().warn("Tried too many times to find random dungeon pos and failed, please delete the map dimension folder", new Object[0]);
                return null;
            }
            int x = RandomUtils.RandomRange((int)50, (int)max);
            int z = RandomUtils.RandomRange((int)50, (int)max);
            pos = new ChunkPos(x, z);
            pos = MapData.getStartChunk(pos.m_151394_(50));
        }
        if (tries > 1000) {
            ExileLog.get().warn("It took more than 1000 tries to find random free dungeon, either you are insanely unlucky, or the world is close to filled! Dungeon worlds are cleared on next server boot if they reach too close to capacity.", new Object[0]);
        }
        return pos;
    }

    public static BlockPos getDungeonStartTeleportPos(BlockPos pos) {
        BlockPos p = MapData.getStartChunk(pos).m_151394_(55);
        p = new BlockPos(p.m_123341_(), 55, p.m_123343_());
        return p;
    }

    public boolean isMapHere(BlockPos pos) {
        ChunkPos cp = MapData.getStartChunk(pos);
        return cp.f_45578_ == this.chunkX && cp.f_45579_ == this.chunkZ;
    }

    public static ChunkPos getStartChunk(BlockPos pos) {
        return MapData.getStartChunk(new ChunkPos(pos));
    }

    public static ChunkPos getStartChunk(ChunkPos cp) {
        int chunkX = cp.f_45578_;
        int chunkZ = cp.f_45579_;
        int distToEntranceX = 11 - chunkX % DUNGEON_LENGTH;
        int distToEntranceZ = 11 - chunkZ % DUNGEON_LENGTH;
        return new ChunkPos(chunkX += distToEntranceX, chunkZ += distToEntranceZ);
    }
}

