/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.maps;

import com.robertx22.library_of_exile.utils.SoundUtils;
import com.robertx22.library_of_exile.utils.geometry.Circle2d;
import com.robertx22.mine_and_slash.database.data.profession.ProfessionBlockEntity;
import com.robertx22.mine_and_slash.maps.MapBlockEntity;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.maps.MapItemData;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.SlashItems;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class MapBlock
extends BaseEntityBlock {
    public MapBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(2.0f).m_60955_());
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        try {
            if (pLevel.f_46443_) {
                SimpleParticleType particle = ParticleTypes.f_123771_;
                Circle2d c = new Circle2d(pPos, 1.5f);
                SimpleParticleType finalParticle = particle;
                c.doXTimes(5, x -> c.spawnParticle(pLevel, c.getRandomEdgePos(), (ParticleOptions)finalParticle));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void m_6810_(BlockState pState, Level level, BlockPos p, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockentity;
        if (!pState.m_60713_(pNewState.m_60734_()) && (blockentity = level.m_7702_(p)) instanceof ProfessionBlockEntity) {
            ProfessionBlockEntity be = (ProfessionBlockEntity)blockentity;
            if (level instanceof ServerLevel) {
                ItemEntity en = new ItemEntity(level, (double)p.m_123341_(), (double)p.m_123342_(), (double)p.m_123343_(), this.m_5456_().m_7968_());
                level.m_7967_((Entity)en);
            }
        }
        super.m_6810_(pState, level, p, pNewState, pIsMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new MapBlockEntity(pPos, pState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState pState, Level level, BlockPos pPos, Player p, InteractionHand pHand, BlockHitResult pHit) {
        if (!level.f_46443_) {
            MapItemData data = (MapItemData)StackSaving.MAP.loadFrom(p.m_21120_(pHand));
            if (WorldUtils.isDungeonWorld(level)) {
                Load.player((Player)p).map.teleportBack(p);
            } else {
                if (data != null) {
                    if (Load.Unit((Entity)p).getLevel() < data.lvl - 5) {
                        p.m_213846_((Component)Chats.TOO_LOW_LEVEL.locName().m_130940_(ChatFormatting.RED));
                        return InteractionResult.FAIL;
                    }
                    if (!data.getStatReq().meetsReq(data.lvl, Load.Unit((Entity)p))) {
                        p.m_213846_((Component)Chats.RESISTS_TOO_LOW_FOR_MAP.locName().m_130940_(ChatFormatting.RED));
                        List<Component> reqDifference = data.getStatReq().getReqDifference(data.lvl, Load.Unit((Entity)p));
                        if (!reqDifference.isEmpty()) {
                            p.m_213846_((Component)Chats.NOT_MEET_MAP_REQ_FIRST_LINE.locName().m_130940_(ChatFormatting.RED));
                            reqDifference.forEach(arg_0 -> ((Player)p).m_213846_(arg_0));
                        }
                        return InteractionResult.FAIL;
                    }
                    Load.worldData((Level)level).map.startNewMap(p, data);
                    SoundUtils.playSound((Entity)p, (SoundEvent)SoundEvents.f_11871_);
                    MapBlockEntity be = (MapBlockEntity)level.m_7702_(pPos);
                    be.setMap(p.m_20149_());
                    if (!p.m_7500_()) {
                        p.m_21120_(pHand).m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (p.m_21120_(pHand).m_150930_(SlashItems.MAP_SETTER.get())) {
                    MapBlockEntity be = (MapBlockEntity)level.m_7702_(pPos);
                    be.setMap(p.m_20149_());
                    return InteractionResult.SUCCESS;
                }
                MapBlockEntity be = (MapBlockEntity)level.m_7702_(pPos);
                Optional<MapData> map = Load.worldData((Level)level).map.getMapFromPlayerID(be.getMapId());
                if (map.isPresent()) {
                    MapData mapData = map.get();
                    if (mapData.getLives(p) < 1) {
                        p.m_213846_((Component)Chats.NO_MORE_LIVES_REMAINING.locName().m_130940_(ChatFormatting.RED));
                        return InteractionResult.FAIL;
                    }
                    MapItemData map1 = mapData.map;
                    if (!map1.getStatReq().meetsReq(map1.lvl, Load.Unit((Entity)p))) {
                        p.m_213846_((Component)Chats.RESISTS_TOO_LOW_FOR_MAP.locName().m_130940_(ChatFormatting.RED));
                        List<Component> reqDifference = map1.getStatReq().getReqDifference(map1.lvl, Load.Unit((Entity)p));
                        if (!reqDifference.isEmpty()) {
                            p.m_213846_((Component)Chats.NOT_MEET_MAP_REQ_FIRST_LINE.locName().m_130940_(ChatFormatting.RED));
                            reqDifference.forEach(arg_0 -> ((Player)p).m_213846_(arg_0));
                        }
                        return InteractionResult.FAIL;
                    }
                    if (Load.Unit((Entity)p).getLevel() < map1.lvl - 5) {
                        p.m_213846_((Component)Chats.TOO_LOW_LEVEL.locName().m_130940_(ChatFormatting.RED));
                        return InteractionResult.FAIL;
                    }
                    if (p.m_150109_().m_18947_(SlashItems.TP_BACK.get()) < 1) {
                        p.m_213846_((Component)Chats.NEED_PEARL.locName(SlashItems.TP_BACK.get().m_7968_().m_41786_()));
                        return InteractionResult.SUCCESS;
                    }
                    mapData.teleportToMap(p);
                } else {
                    return InteractionResult.FAIL;
                }
            }
        }
        return InteractionResult.SUCCESS;
    }
}

