/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.req;

import com.robertx22.mine_and_slash.database.data.league.LeagueMechanic;

public class DropRequirement {
    private String league = "";
    int req_lvl = 0;

    private DropRequirement() {
    }

    public boolean canDropInLeague(LeagueMechanic m, int lvl) {
        if (lvl < this.req_lvl) {
            return false;
        }
        if (this.league.isEmpty()) {
            return true;
        }
        return m.GUID().equals(this.league);
    }

    public boolean isFromLeague(LeagueMechanic m) {
        return m.GUID().equals(this.league);
    }

    public static class Builder {
        DropRequirement r;

        public Builder(DropRequirement r) {
            this.r = r;
        }

        public static Builder of() {
            return new Builder(new DropRequirement());
        }

        public Builder setOnlyDropsInLeague(String le) {
            this.r.league = le;
            return this;
        }

        public Builder setLevelReq(int lvl) {
            this.r.req_lvl = lvl;
            return this;
        }

        public DropRequirement build() {
            return this.r;
        }
    }
}

