/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.generators;

import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.content.ubers.UberBossArena;
import com.robertx22.mine_and_slash.content.ubers.UberBossTier;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.ItemBlueprint;
import com.robertx22.mine_and_slash.loot.generators.BaseLootGen;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.SlashItems;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.enumclasses.LootType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class UberFragLootGen
extends BaseLootGen<ItemBlueprint> {
    public UberFragLootGen(LootInfo info) {
        super(info);
    }

    @Override
    public float baseDropChance() {
        return ((Double)ServerContainer.get().UBER_FRAG_DROPRATE.get()).floatValue();
    }

    @Override
    public LootType lootType() {
        return LootType.UberFrag;
    }

    @Override
    public boolean condition() {
        MapData map = Load.mapAt(this.info.world, this.info.pos);
        if (map == null || map.map.isUber()) {
            return false;
        }
        return this.info.level >= UberBossTier.T1.frag_drop_lvl;
    }

    @Override
    public ItemStack generateOne() {
        MapData map = Load.mapAt(this.info.world, this.info.pos);
        UberBossTier tier = UberBossTier.getTierForFragmentDrop(this.info.level);
        UberBossArena uber = (UberBossArena)ExileDB.UberBoss().getFilterWrapped(x -> true).random();
        Item item = SlashItems.UBER_FRAGS.get((Object)uber.getEnum()).get(tier.tier).get();
        ItemStack stack = new ItemStack((ItemLike)item);
        return stack;
    }
}

