/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.generators;

import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.database.data.profession.LeveledItem;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.ItemBlueprint;
import com.robertx22.mine_and_slash.loot.generators.BaseLootGen;
import com.robertx22.mine_and_slash.uncommon.coins.Coin;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.enumclasses.LootType;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LevelUtils;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ProphecyCoinLootGen
extends BaseLootGen<ItemBlueprint> {
    public ProphecyCoinLootGen(LootInfo info) {
        super(info);
    }

    @Override
    public float baseDropChance() {
        float chance = ((Double)ServerContainer.get().PROPHECY_COIN_DROPRATE.get()).floatValue();
        chance *= 1.0f + (float)this.info.map_tier / 25.0f;
        return chance *= (float)Load.player((Player)this.info.player).prophecy.affixesTaken.size();
    }

    @Override
    public boolean chanceIsModified() {
        return true;
    }

    @Override
    public LootType lootType() {
        return LootType.ProphecyCoin;
    }

    @Override
    public boolean condition() {
        return this.info.isMapWorld && this.info.map != null && this.info.player != null && !Load.player((Player)this.info.player).prophecy.affixesTaken.isEmpty();
    }

    @Override
    public boolean hasLevelDistancePunishment() {
        return true;
    }

    @Override
    public ItemStack generateOne() {
        ItemStack s = new ItemStack((ItemLike)Coin.PROPHECY.getItem());
        LeveledItem.setTier(s, LevelUtils.levelToTier(this.info.level));
        return s;
    }
}

