/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.generators;

import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.MapBlueprint;
import com.robertx22.mine_and_slash.loot.generators.BaseLootGen;
import com.robertx22.mine_and_slash.uncommon.enumclasses.LootType;
import net.minecraft.world.item.ItemStack;

public class MapLootGen
extends BaseLootGen<MapBlueprint> {
    public MapLootGen(LootInfo info) {
        super(info);
    }

    @Override
    public float baseDropChance() {
        if (this.info.isMapWorld) {
            return ((Double)ServerContainer.get().MAP_DROPRATE_INSIDE_MAPS.get()).floatValue();
        }
        return ((Double)ServerContainer.get().MAP_DROPRATE.get()).floatValue();
    }

    @Override
    public LootType lootType() {
        return LootType.Map;
    }

    @Override
    public boolean condition() {
        if (((Boolean)ServerContainer.get().MAPS_DONT_DROP_IN_MAPS.get()).booleanValue() && this.info.isMapWorld) {
            return false;
        }
        return (Integer)ServerContainer.get().MIN_LEVEL_MAP_DROPS.get() < this.info.level;
    }

    @Override
    public boolean hasLevelDistancePunishment() {
        return false;
    }

    @Override
    public ItemStack generateOne() {
        MapBlueprint blueprint = new MapBlueprint(this.info);
        return blueprint.createStack();
    }
}

