/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.blueprints;

import com.robertx22.mine_and_slash.content.ubers.UberBossArena;
import com.robertx22.mine_and_slash.content.ubers.UberBossTier;
import com.robertx22.mine_and_slash.database.data.map_affix.MapAffix;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.RarityItemBlueprint;
import com.robertx22.mine_and_slash.maps.MapAffixData;
import com.robertx22.mine_and_slash.maps.MapItemData;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.SlashItems;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MapBlueprint
extends RarityItemBlueprint {
    boolean uberMap = false;
    UberBossTier uberTier = UberBossTier.T1;
    UberBossArena uber;

    public MapBlueprint(LootInfo info) {
        super(info);
    }

    public void setUberBoss(UberBossArena boss, UberBossTier tier) {
        this.uber = boss;
        this.uberTier = tier;
        this.uberMap = true;
    }

    @Override
    public ItemStack generate() {
        MapItemData data = this.createData();
        ItemStack stack = new ItemStack((ItemLike)SlashItems.MAP.get());
        if (this.uberMap) {
            stack.m_41714_((Component)this.uber.locName().m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
        }
        StackSaving.MAP.saveTo(stack, (Object)data);
        return stack;
    }

    public MapItemData createData() {
        MapItemData data = new MapItemData();
        GearRarity rarity = (GearRarity)this.rarity.get();
        data.rar = rarity.GUID();
        data.tier = rarity.getPossibleMapTiers().random();
        data.lvl = (Integer)this.level.get();
        if (this.uberMap) {
            data.uber = this.uber.GUID();
        }
        this.genAffixes(data, rarity);
        return data;
    }

    private MapItemData genAffixes(MapItemData map, GearRarity rarity) {
        int amount = rarity.getAffixAmount() + 2;
        ArrayList<String> affixes = new ArrayList<String>();
        for (int i = 0; i < amount; ++i) {
            MapAffix affix = (MapAffix)ExileDB.MapAffixes().getFilterWrapped(x -> x.req.isEmpty()).random();
            while (affixes.contains(affix.GUID())) {
                affix = (MapAffix)ExileDB.MapAffixes().getFilterWrapped(x -> x.req.isEmpty()).random();
            }
            int percent = rarity.stat_percents.random();
            map.affixes.add(new MapAffixData(affix, percent));
            affixes.add(affix.GUID());
        }
        return map;
    }
}

