/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.blueprints;

import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.database.data.affixes.Affix;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.RarityItemBlueprint;
import com.robertx22.mine_and_slash.saveclasses.jewel.CraftedUniqueJewelData;
import com.robertx22.mine_and_slash.saveclasses.jewel.JewelItemData;
import com.robertx22.mine_and_slash.saveclasses.jewel.StatsWhileUnderAuraData;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.enumclasses.PlayStyle;
import java.util.Arrays;
import net.minecraft.world.item.ItemStack;

public class JewelBlueprint
extends RarityItemBlueprint {
    public boolean isEye = false;
    public int auraAffixes = 0;

    public JewelBlueprint(LootInfo info) {
        super(info);
        this.rarity.chanceForHigherRarity = 50.0f;
        this.rarity.canRollUnique = false;
    }

    @Override
    public ItemStack generate() {
        JewelItemData data = this.createData();
        ItemStack stack = data.getItem().m_7968_();
        StackSaving.JEWEL.saveTo(stack, (Object)data);
        return stack;
    }

    public JewelItemData createData() {
        JewelItemData data = new JewelItemData();
        PlayStyle style = (PlayStyle)((Object)RandomUtils.randomFromList(Arrays.stream(PlayStyle.values()).toList()));
        if (this.isEye) {
            data.style = PlayStyle.INT.id;
            data.rar = "unique";
            data.uniq = new CraftedUniqueJewelData();
            data.uniq.id = CraftedUniqueJewelData.WATCHER_EYE;
            while (data.auraStats.size() < this.auraAffixes) {
                Affix affix = (Affix)ExileDB.Affixes().getFilterWrapped(x -> x.type == Affix.Type.watcher_eye).random();
                if (!data.auraStats.stream().noneMatch(x -> x.affix.equals(affix.GUID()))) continue;
                data.auraStats.add(new StatsWhileUnderAuraData(affix, (Integer)this.level.get()));
            }
        } else {
            data.rar = ((GearRarity)this.rarity.get()).GUID();
            data.style = style.id;
        }
        data.lvl = this.info.level;
        data.generateAffixes();
        return data;
    }
}

