/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot;

import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.library_of_exile.utils.SoundUtils;
import com.robertx22.mine_and_slash.capability.player.data.PlayerConfigData;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.generators.AuraGemLootGen;
import com.robertx22.mine_and_slash.loot.generators.CurrencyLootGen;
import com.robertx22.mine_and_slash.loot.generators.GearLootGen;
import com.robertx22.mine_and_slash.loot.generators.GemLootGen;
import com.robertx22.mine_and_slash.loot.generators.JewelLootGen;
import com.robertx22.mine_and_slash.loot.generators.LootChestGen;
import com.robertx22.mine_and_slash.loot.generators.MapLootGen;
import com.robertx22.mine_and_slash.loot.generators.ProphecyCoinLootGen;
import com.robertx22.mine_and_slash.loot.generators.RuneLootGen;
import com.robertx22.mine_and_slash.loot.generators.SoulLootGen;
import com.robertx22.mine_and_slash.loot.generators.SuppGemLootGen;
import com.robertx22.mine_and_slash.loot.generators.UberFragLootGen;
import com.robertx22.mine_and_slash.loot.generators.WatcherEyeLootGen;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MasterLootGen {
    public static List<ItemStack> generateLoot(LootInfo info) {
        List<ItemStack> items = new ArrayList<ItemStack>();
        try {
            if (info == null) {
                return items;
            }
            items = MasterLootGen.populateOnce(info);
            int tries = 0;
            while (items.size() < info.getMinItems()) {
                if (++tries > 20) {
                    ExileLog.get().warn("Tried to generate loot many times but failed! " + info.toString(), new Object[0]);
                    break;
                }
                List<ItemStack> extra = MasterLootGen.populateOnce(info);
                if (extra.isEmpty()) continue;
                items.add((ItemStack)RandomUtils.randomFromList(extra));
            }
            tries = 0;
            while (items.size() > info.getMaxItems()) {
                if (++tries > 50) {
                    ExileLog.get().warn("Took too many tries to remove items from masterlootgen", new Object[0]);
                    break;
                }
                items.remove(RandomUtils.RandomRange((int)0, (int)(items.size() - 1)));
            }
            items.forEach(x -> ItemUtils.tryAnnounceItem(x, info.player));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return items;
    }

    private static List<ItemStack> populateOnce(LootInfo info) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (info == null) {
            return items;
        }
        try {
            items.addAll(new GearLootGen(info).tryGenerate());
            items.addAll(new SoulLootGen(info).tryGenerate());
            items.addAll(new UberFragLootGen(info).tryGenerate());
            items.addAll(new AuraGemLootGen(info).tryGenerate());
            items.addAll(new SuppGemLootGen(info).tryGenerate());
            items.addAll(new JewelLootGen(info).tryGenerate());
            items.addAll(new CurrencyLootGen(info).tryGenerate());
            items.addAll(new MapLootGen(info).tryGenerate());
            items.addAll(new GemLootGen(info).tryGenerate());
            items.addAll(new RuneLootGen(info).tryGenerate());
            items.addAll(new LootChestGen(info).tryGenerate());
            items.addAll(new WatcherEyeLootGen(info).tryGenerate());
            items.addAll(new ProphecyCoinLootGen(info).tryGenerate());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return items.stream().filter(x -> x != null && !x.m_41619_()).collect(Collectors.toList());
    }

    public static List<ItemStack> generateLoot(LivingEntity victim, Player killer) {
        LootInfo info = LootInfo.ofMobKilled(killer, victim);
        info.gatherLootMultipliers();
        List<ItemStack> items = MasterLootGen.generateLoot(info);
        if (Load.player((Player)killer).config.isConfigEnabled(PlayerConfigData.Config.MOB_DEATH_MESSAGES)) {
            MutableComponent hovertext = info.lootMods.getHoverText();
            HoverEvent hover = new HoverEvent(HoverEvent.Action.f_130831_, (Object)hovertext);
            MutableComponent msg = Words.MOB_KILL_LOOT_INFO_MSG.locName(victim.m_5446_()).m_130940_(ChatFormatting.GREEN);
            msg = msg.m_7220_((Component)Words.MOB_DROPS_INFO.locName(items.size()).m_130948_(Style.f_131099_.m_131144_(hover).m_131152_(new ChatFormatting[]{ChatFormatting.YELLOW})));
            killer.m_213846_((Component)msg);
        }
        return items;
    }

    public static void genAndDrop(LivingEntity victim, Player killer) {
        List<ItemStack> items = MasterLootGen.generateLoot(victim, killer);
        for (ItemStack stack : items) {
            if (StackSaving.GEARS.has(stack)) {
                GearRarity rar = ((GearItemData)StackSaving.GEARS.loadFrom(stack)).getRarity();
                if (rar.is_unique_item) {
                    SoundUtils.ding((Level)victim.m_9236_(), (BlockPos)victim.m_20183_());
                }
            }
            victim.m_5552_(stack, 1.0f);
        }
    }
}

