/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot;

import com.robertx22.library_of_exile.events.base.ExileEvent;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.database.data.league.LeagueMechanic;
import com.robertx22.mine_and_slash.database.data.league.LeagueMechanics;
import com.robertx22.mine_and_slash.database.data.league.LeagueStructure;
import com.robertx22.mine_and_slash.database.data.stats.types.loot.TreasureQuantity;
import com.robertx22.mine_and_slash.database.data.stats.types.misc.ExtraMobDropsStat;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.loot.LootModifier;
import com.robertx22.mine_and_slash.loot.LootModifierEnum;
import com.robertx22.mine_and_slash.loot.LootModifiersList;
import com.robertx22.mine_and_slash.loot.LootUtils;
import com.robertx22.mine_and_slash.loot.generators.BaseLootGen;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LevelUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class LootInfo {
    public int amount = 0;
    public int level = 0;
    public int map_tier = 0;
    public LootOrigin lootOrigin;
    public EntityData mobData;
    public EntityData playerEntityData;
    public LivingEntity mobKilled;
    public Player player;
    public Level world;
    private int minItems = 0;
    private int maxItems = 50;
    public boolean isMapWorld = false;
    public MapData map;
    public BlockPos pos;
    public LeagueMechanic league = LeagueMechanics.NONE;
    public LootModifiersList lootMods = new LootModifiersList();
    private boolean gatheredLootMultis = false;

    private LootInfo(LootOrigin lootOrigin) {
        this.lootOrigin = lootOrigin;
    }

    public int getMinItems() {
        return this.minItems;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public static LootInfo ofMobKilled(Player player, LivingEntity mob) {
        LootInfo info = new LootInfo(LootOrigin.MOB);
        try {
            info.world = mob.m_9236_();
            info.mobData = Load.Unit((Entity)mob);
            info.playerEntityData = Load.Unit((Entity)player);
            info.mobKilled = mob;
            info.player = player;
            info.pos = mob.m_20183_();
            info.setupAllFields();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return info;
    }

    public static LootInfo ofPlayer(Player player) {
        LootInfo info = new LootInfo(LootOrigin.PLAYER);
        info.world = player.m_9236_();
        info.pos = player.m_20183_();
        info.setupAllFields();
        return info;
    }

    public static LootInfo ofChestLoot(Player player, BlockPos pos) {
        LootInfo info = new LootInfo(LootOrigin.CHEST);
        info.player = player;
        info.world = player.m_9236_();
        info.pos = pos;
        info.maxItems = 7;
        info.setupAllFields();
        if (WorldUtils.isMapWorldClass(player.m_9236_())) {
            info.lootMods.add(new LootModifier(LootModifierEnum.MAP_CHEST, 10.0f));
        } else {
            info.lootMods.add(new LootModifier(LootModifierEnum.CHEST, 5.0f));
        }
        return info;
    }

    public static LootInfo ofDummyForClient(int level) {
        LootInfo info = new LootInfo(LootOrigin.OTHER);
        info.level = level;
        info.setupAllFields();
        return info;
    }

    public static LootInfo ofLevel(int level) {
        LootInfo info = new LootInfo(LootOrigin.OTHER);
        info.level = level;
        info.setupAllFields();
        return info;
    }

    public static LootInfo ofSpawner(Player player, Level world, BlockPos pos) {
        LootInfo info = new LootInfo(LootOrigin.OTHER);
        info.world = world;
        info.pos = pos;
        info.player = player;
        info.setupAllFields();
        info.maxItems = 1;
        return info;
    }

    private void setupAllFields() {
        this.errorIfClient();
        this.setWorld();
        this.setTier();
        this.setLevel();
        if (this.player != null) {
            this.playerEntityData = Load.Unit((Entity)this.player);
        }
    }

    private LootInfo setTier() {
        if (this.map != null) {
            this.map_tier = this.map.map.tier;
        }
        return this;
    }

    private void setLevel() {
        if (this.level <= 0) {
            this.level = this.mobData != null ? this.mobData.getLevel() : LevelUtils.determineLevel(null, this.world, this.pos, this.player, false).getLevel();
        }
    }

    private void errorIfClient() {
        if (this.world != null && this.world.f_46443_) {
            throw new RuntimeException("Can't use Loot Info on client side!!!");
        }
    }

    private void setWorld() {
        Optional<MapData> data;
        if (this.world != null && WorldUtils.isMapWorldClass(this.world) && (data = Load.worldData((Level)this.world).map.getMap(this.pos)).get() != null) {
            this.isMapWorld = true;
            this.map = data.get();
            this.league = LeagueStructure.getMechanicFromPosition((ServerLevel)this.world, this.pos);
        }
    }

    public void gatherLootMultipliers() {
        if (this.gatheredLootMultis) {
            return;
        }
        this.gatheredLootMultis = true;
        if (this.mobKilled != null && this.mobData != null) {
            if (this.playerEntityData != null) {
                this.lootMods.add(new LootModifier(LootModifierEnum.LEVEL_DISTANCE_PENALTY, LootUtils.getLevelDistancePunishmentMulti(this.mobData.getLevel(), this.playerEntityData.getLevel())));
            }
            this.lootMods.add(new LootModifier(LootModifierEnum.MOB_HEALTH, LootUtils.getMobHealthBasedLootMulti(this.mobKilled)));
            this.lootMods.add(new LootModifier(LootModifierEnum.MOB_DATAPACK, (float)ExileDB.getEntityConfig((LivingEntity)this.mobKilled, (EntityData)this.mobData).loot_multi));
            this.lootMods.add(new LootModifier(LootModifierEnum.MOB_BONUS_LOOT_STAT, this.mobData.getUnit().getCalculatedStat(ExtraMobDropsStat.getInstance()).getMultiplier()));
            this.lootMods.add(new LootModifier(LootModifierEnum.MOB_RARITY, this.mobData.getMobRarity().LootMultiplier()));
        }
        if (this.playerEntityData != null) {
            if (this.playerEntityData.getLevel() < 10) {
                this.lootMods.add(new LootModifier(LootModifierEnum.LOW_LEVEL_BOOST, 2.0f));
            }
            this.lootMods.add(new LootModifier(LootModifierEnum.FAVOR, Load.player((Player)this.player).favor.getLootExpMulti()));
            if (this.lootOrigin != LootOrigin.LOOT_CRATE) {
                this.lootMods.add(new LootModifier(LootModifierEnum.PLAYER_LOOT_QUANTITY, this.playerEntityData.getUnit().getCalculatedStat(TreasureQuantity.getInstance()).getMultiplier()));
            }
        }
        if (this.world != null) {
            this.lootMods.add(new LootModifier(LootModifierEnum.DIMENSION_LOOT, ExileDB.getDimensionConfig((LevelAccessor)this.world).all_drop_multi));
        }
        if (this.isMapWorld) {
            this.lootMods.add(new LootModifier(LootModifierEnum.ADVENTURE_MAP, this.map.map.getBonusLootMulti()));
        } else {
            float chance = ((ExileEvents.OnSetupLootChance)ExileEvents.SETUP_LOOT_CHANCE.callEvents((ExileEvent)new ExileEvents.OnSetupLootChance((LivingEntity)this.mobKilled, (Player)this.player, (float)1.0f))).lootChance;
            this.lootMods.add(new LootModifier(LootModifierEnum.ANTI_MOB_FARM_MOD, chance));
        }
    }

    public void setup(BaseLootGen gen) {
        float multiplicativeMod = 1.0f;
        this.gatherLootMultipliers();
        for (LootModifier mod : this.lootMods.all) {
            multiplicativeMod *= mod.multi;
        }
        float chance = gen.baseDropChance();
        if (gen.chanceIsModified()) {
            chance *= multiplicativeMod;
        }
        this.amount = LootUtils.WhileRoll(chance);
    }

    public static enum LootOrigin {
        CHEST,
        MOB,
        PLAYER,
        OTHER,
        LOOT_CRATE;

    }
}

