/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.wiki;

import com.robertx22.library_of_exile.utils.CLOC;
import com.robertx22.library_of_exile.utils.RenderUtils;
import com.robertx22.library_of_exile.utils.TextUTIL;
import com.robertx22.mine_and_slash.gui.bases.BaseScreen;
import com.robertx22.mine_and_slash.gui.bases.INamedScreen;
import com.robertx22.mine_and_slash.gui.screens.character_screen.MainHubScreen;
import com.robertx22.mine_and_slash.gui.wiki.BaseScrollbar;
import com.robertx22.mine_and_slash.gui.wiki.BestiaryEntry;
import com.robertx22.mine_and_slash.gui.wiki.BestiaryGroup;
import com.robertx22.mine_and_slash.gui.wiki.all.CurrencyBestiary;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class BestiaryScreen
extends BaseScreen
implements INamedScreen {
    ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("mmorpg", "textures/gui/bestiary/bestiary.png");
    ResourceLocation BUTTON_TEXTURE = new ResourceLocation("mmorpg", "textures/gui/bestiary/buttons.png");
    ResourceLocation SPLITTER_BUTTON_TEXTURE = new ResourceLocation("mmorpg", "textures/gui/bestiary/split.png");
    ResourceLocation GROUP_BUTTON_TEXTURE = new ResourceLocation("mmorpg", "textures/gui/bestiary/bestiary_group_buttons.png");
    public Minecraft mc;
    public static int entryButtonX = 235;
    public static int entryButtonY = 24;
    public static int groupButtonX = 20;
    public static int groupButtonY = 20;
    Scrollbar scrollbar;
    static int x = 276;
    static int y = 200;
    public BestiaryGroup currentBestiaryGroup = new CurrencyBestiary();
    int currentElement = 0;
    public List<BestiaryEntry> entries = new ArrayList<BestiaryEntry>();
    int level = 1;
    int elementsAmount = 1;
    int entryButtonsAtOnce = 7;

    public BestiaryScreen() {
        super(x, y);
        this.mc = Minecraft.m_91087_();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_6702_().clear();
        this.f_169369_.clear();
        this.m_142416_((GuiEventListener)new BackButton(this.guiLeft, this.guiTop - BackButton.ySize));
        this.level = Load.Unit((Entity)this.mc.f_91074_).getLevel();
        this.initEntries();
        this.setupEntryButtons();
        this.setupGroupButtons();
        this.setupScrollbar();
    }

    public void setupScrollbar() {
        int sliderXSize = 10;
        int sliderYSize = 30;
        int sliderX = this.guiLeft + 262;
        int sliderY = this.guiTop + 18;
        this.scrollbar = (Scrollbar)this.m_142416_((GuiEventListener)new Scrollbar(sliderX, sliderY, 174));
    }

    public void initEntries() {
        this.entries = this.currentBestiaryGroup.getAll(1);
        this.elementsAmount = this.entries.size();
    }

    public void setupGroupButtons() {
        int gx = this.guiLeft + 5;
        int gy = this.guiTop + 18;
        for (BestiaryGroup bestiaryGroup : BestiaryGroup.getAll()) {
            this.m_142416_((GuiEventListener)new GroupButton(this, bestiaryGroup, gx, gy));
            gy += groupButtonY;
        }
    }

    public void setupEntryButtons() {
        int x = this.guiLeft + 27;
        int y = this.guiTop + 19;
        for (int i = this.currentElement; i < this.currentElement + this.entryButtonsAtOnce; ++i) {
            if (i >= this.elementsAmount) continue;
            BestiaryEntry entry = this.entries.get(i);
            this.m_142416_((GuiEventListener)new EntryButton(entry, x, y));
            y += entryButtonY + 0;
        }
    }

    public void m_88315_(GuiGraphics gui, int x, int y, float ticks) {
        try {
            gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            gui.m_280163_(this.BACKGROUND_TEXTURE, this.mc.m_91268_().m_85445_() / 2 - this.sizeX / 2, this.mc.m_91268_().m_85446_() / 2 - this.sizeY / 2, 0.0f, 0.0f, this.sizeX, this.sizeY, 512, 256);
            super.m_88315_(gui, x, y, ticks);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ResourceLocation iconLocation() {
        return new ResourceLocation("mmorpg", "textures/gui/main_hub/icons/wiki.png");
    }

    @Override
    public Words screenName() {
        return Words.WIKI;
    }

    public boolean m_6050_(double num1, double num2, double num3) {
        this.setCurrentElement((int)((double)this.currentElement - num3));
        return super.m_6050_(num1, num2, num3);
    }

    public void setCurrentElement(int element) {
        this.currentElement = MathHelper.clamp(element, 0, this.elementsAmount);
        this.scrollbar.setValueFromElement(this.currentElement, this.elementsAmount);
        this.m_7856_();
    }

    public boolean m_6348_(double m1, double m2, int m3) {
        this.m_7897_(false);
        return super.m_6348_(m1, m2, m3);
    }

    public void setGroup(BestiaryGroup group) {
        this.currentBestiaryGroup = group;
        this.initEntries();
        this.setCurrentElement(0);
        this.m_7856_();
    }

    static class BackButton
    extends ImageButton {
        static ResourceLocation BACK_BUTTON = new ResourceLocation("mmorpg", "textures/gui/back_button.png");
        public static int xSize = 26;
        public static int ySize = 16;

        public BackButton(int xPos, int yPos) {
            super(xPos, yPos, xSize, ySize, 0, 0, ySize + 1, BACK_BUTTON, button -> Minecraft.m_91087_().m_91152_((Screen)new MainHubScreen()));
        }
    }

    class Scrollbar
    extends BaseScrollbar {
        protected Scrollbar(int xpos, int ypos, int scrollbarTotalHeight) {
            super(xpos, ypos, scrollbarTotalHeight);
        }

        @Override
        protected void applyValue() {
            BestiaryScreen.this.setCurrentElement((int)(this.value * (double)BestiaryScreen.this.elementsAmount));
        }

        protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
        }
    }

    class GroupButton
    extends ImageButton {
        BestiaryGroup group;
        BestiaryScreen screen;

        public GroupButton(BestiaryScreen screen, BestiaryGroup group, int xPos, int yPos) {
            super(xPos, yPos, groupButtonX, groupButtonY, 0, 0, groupButtonY, BestiaryScreen.this.GROUP_BUTTON_TEXTURE, button -> {});
            this.screen = screen;
            this.group = group;
        }

        public void m_5691_() {
            super.m_5691_();
            this.screen.setGroup(this.group);
        }

        public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
            this.setModTooltip();
            super.m_88315_(gui, mouseX, mouseY, delta);
            RenderUtils.render16Icon((GuiGraphics)gui, (ResourceLocation)this.group.getTextureLoc(), (int)(this.m_252754_() + 2), (int)(this.m_252907_() + 2));
        }

        public void setModTooltip() {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237113_((String)(ChatFormatting.BLUE + ChatFormatting.BOLD + CLOC.translate((FormattedText)this.group.getName()))));
            this.m_257544_(Tooltip.m_257550_((Component)TextUTIL.mergeList(tooltip)));
        }
    }

    class EntryButton
    extends ImageButton {
        BestiaryEntry item;

        public EntryButton(BestiaryEntry item, int xPos, int yPos) {
            super(xPos, yPos, entryButtonX, entryButtonY, 0, 0, entryButtonY, BestiaryScreen.this.BUTTON_TEXTURE, button -> {});
            this.item = item;
        }

        int getStackY() {
            return this.m_252907_() + 4;
        }

        int getStackX() {
            return this.m_252754_() + 13;
        }

        public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
            if (this.m_274382_()) {
                this.setModTooltip();
            }
            super.m_88315_(gui, mouseX, mouseY, delta);
            gui.m_280203_(this.item.stack, this.getStackX(), this.getStackY());
            int xp = this.m_252754_() + 37;
            int n = this.m_252907_() + entryButtonY / 2;
            Objects.requireNonNull(BestiaryScreen.this.mc.f_91062_);
            int yp = n - 9 / 2;
            gui.m_280488_(BestiaryScreen.this.mc.f_91062_, this.item.getName(), xp, yp, ChatFormatting.GREEN.m_126665_().intValue());
        }

        public void setModTooltip() {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.addAll(this.item.getTooltip());
            this.m_257544_(Tooltip.m_257550_((Component)TextUTIL.mergeList(tooltip)));
        }
    }
}

