/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.wiki;

import com.robertx22.mine_and_slash.uncommon.MathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class BaseScrollbar
extends AbstractWidget {
    static ResourceLocation SCROLLBAR_TEXTURE = new ResourceLocation("mmorpg", "textures/gui/scrollbar.png");
    static int sizeY = 27;
    static int sizeX = 6;
    protected double value = 0.0;
    int totalHeight;

    protected BaseScrollbar(int xpos, int ypos, int scrollbarTotalHeight) {
        super(xpos, ypos, sizeX, scrollbarTotalHeight, (Component)Component.m_237119_());
        this.totalHeight = scrollbarTotalHeight;
    }

    public void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        int xadd = (this.m_274382_() ? 1 : 0) * sizeX;
        int yPos = this.getScrollBarY();
        gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        gui.m_280218_(SCROLLBAR_TEXTURE, this.m_252754_(), this.m_252907_(), 50, 0, sizeX, this.totalHeight);
        gui.m_280218_(SCROLLBAR_TEXTURE, this.m_252754_(), yPos, xadd, 0, sizeX, sizeY);
    }

    public int getScrollBarY() {
        int val = (int)((double)this.m_252907_() + this.value * (double)this.totalHeight);
        return MathHelper.clamp(val - sizeY / 2, this.m_252907_(), this.m_252907_() + this.totalHeight - sizeY);
    }

    public void m_5716_(double x, double y) {
        this.setValueFromMouse(y);
    }

    private void setValueFromMouse(double y) {
        this.setValue((y - (double)this.m_252907_()) / (double)this.totalHeight);
    }

    private void setValue(double y) {
        double val = this.value;
        this.value = MathHelper.clamp((float)y, 0.0f, 1.0f);
        if (val != this.value) {
            this.applyValue();
        }
    }

    public void setValueFromElement(int element, int max) {
        this.value = (float)element / (float)max;
    }

    protected void m_7212_(double x, double y, double f3, double f4) {
        this.setValueFromMouse(y);
        super.m_7212_(x, y, f3, f4);
    }

    public void m_7691_(double x, double y) {
        super.m_7435_(Minecraft.m_91087_().m_91106_());
    }

    protected abstract void applyValue();
}

