/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.texts.textblocks;

import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.gui.texts.ExileTooltips;
import com.robertx22.mine_and_slash.gui.texts.textblocks.AbstractTextBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.RarityListData;
import com.robertx22.mine_and_slash.mmorpg.UNICODE;
import com.robertx22.mine_and_slash.uncommon.localization.Gui;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ClientOnly;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class WorksOnBlock
extends AbstractTextBlock {
    RarityListData rarities = null;
    MutableComponent name;
    List<ItemType> items = new ArrayList<ItemType>();

    public static WorksOnBlock usableOn(ItemType type) {
        return new WorksOnBlock(Type.USABLE_ON).itemTypes(type);
    }

    public static WorksOnBlock possibleDrops(List<GearRarity> rar) {
        return new WorksOnBlock(Type.POSSIBLE_GEAR_DROPS).rarities(rar);
    }

    private WorksOnBlock(Type name) {
        this.name = name.name.locName();
    }

    public WorksOnBlock rarities(List<GearRarity> rar) {
        this.rarities = new RarityListData(rar);
        return this;
    }

    private WorksOnBlock itemTypes(ItemType ... item) {
        this.items.addAll(Arrays.asList(item));
        return this;
    }

    List<MutableComponent> itemTypesTooltip() {
        ArrayList<MutableComponent> all = new ArrayList<MutableComponent>();
        MutableComponent types = Component.m_237113_((String)(UNICODE.STAR + " ")).m_7220_((Component)Words.ITEM_TYPES.locName()).m_130940_(ChatFormatting.GREEN);
        if (Screen.m_96638_()) {
            all.add(types);
            for (ItemType type : this.items) {
                all.add(Component.m_237113_((String)(UNICODE.ROTATED_CUBE + " ")).m_7220_((Component)type.name.locName()).m_130940_(ChatFormatting.YELLOW));
                MutableComponent desc = Component.m_237113_((String)"[").m_7220_((Component)type.desc.locName().m_130940_(ChatFormatting.BLUE)).m_130946_("]");
                all.add(desc);
            }
        } else {
            MutableComponent c = Component.m_237113_((String)(" " + UNICODE.ROTATED_CUBE + " ")).m_7220_((Component)TooltipUtils.joinMutableComps(this.items.stream().map(x -> x.name.locName()).iterator(), Gui.COMMA_SEPARATOR.locName())).m_130940_(ChatFormatting.YELLOW);
            all.add(types.m_7220_((Component)c));
        }
        return all;
    }

    @Override
    public List<? extends Component> getAvailableComponents() {
        ArrayList<MutableComponent> all = new ArrayList<MutableComponent>();
        all.add(this.name.m_130940_(ChatFormatting.AQUA));
        if (!this.items.isEmpty()) {
            for (MutableComponent m : this.itemTypesTooltip()) {
                all.add(Component.m_237113_((String)" ").m_7220_((Component)m));
            }
        }
        if (this.rarities != null) {
            for (MutableComponent m : this.rarities.getTooltip()) {
                all.add(Component.m_237113_((String)" ").m_7220_((Component)m));
            }
        }
        all.add(Itemtips.DRAG_AND_DROP_TO_USE.locName().m_130940_(ChatFormatting.BLUE));
        if (Screen.m_96638_()) {
            all.add(Itemtips.DRAG_AND_DROP_TO_USE_DESC.locName().m_130940_(ChatFormatting.AQUA));
        }
        if (ClientOnly.getPlayer().m_7500_()) {
            all.add(Words.DRAG_NO_WORK_CREATIVE.locName().m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
        }
        return all;
    }

    @Override
    public ExileTooltips.BlockCategories getCategory() {
        return ExileTooltips.BlockCategories.OPERATION;
    }

    public static enum Type {
        USABLE_ON(Words.USABLE_ON),
        POSSIBLE_GEAR_DROPS(Words.POSSIBLE_DROPS);

        public Words name;

        private Type(Words name) {
            this.name = name;
        }
    }

    public static enum ItemType {
        GEAR(Words.Gear, Words.Gear_DESC),
        TOOLS(Words.TOOL, Words.TOOL_DESC),
        JEWEL(Words.Jewel, Words.Jewel_DESC),
        MAP(Words.Map, Words.MapDESC),
        SOUL(Words.Soul, Words.Gear_DESC),
        SOULLESS_GEAR(Words.SOULLESS_Gear, Words.SOULLESS_Gear_DESC);

        public Words name;
        public Words desc;

        private ItemType(Words name, Words desc) {
            this.name = name;
            this.desc = desc;
        }
    }
}

