/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.texts;

import com.robertx22.mine_and_slash.gui.texts.IgnoreNullList;
import com.robertx22.mine_and_slash.gui.texts.textblocks.AbstractTextBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.RarityBlock;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class ExileTooltips {
    public static Component EMPTY_LINE = Component.m_237113_((String)"");
    private final List<AbstractTextBlock> blockContainer = new ArrayList<AbstractTextBlock>();

    public ExileTooltips accept(AbstractTextBlock block) {
        this.blockContainer.add(block);
        return this;
    }

    public List<Component> release() {
        IgnoreNullList<Object> list = new IgnoreNullList<Object>();
        Map<BlockCategories, List<AbstractTextBlock>> collect = this.blockContainer.stream().collect(Collectors.groupingBy(AbstractTextBlock::getCategory));
        Optional.ofNullable(collect.get((Object)BlockCategories.NAME)).map(x -> (AbstractTextBlock)x.get(0)).map(AbstractTextBlock::getAvailableComponents).ifPresent(x -> {
            List rarity = (List)collect.get((Object)BlockCategories.RARITY);
            if (rarity != null) {
                for (Component component : x) {
                    list.add(component.m_6881_().m_130940_(((RarityBlock)rarity.get((int)0)).rarity.textFormatting()));
                }
            } else {
                for (Component component : x) {
                    list.add(component.m_6881_().m_130940_(ChatFormatting.WHITE));
                }
            }
        });
        list.add(EMPTY_LINE);
        Stream.of(collect.get((Object)BlockCategories.REQUIREMENT), collect.get((Object)BlockCategories.STAT), collect.get((Object)BlockCategories.USAGE), collect.get((Object)BlockCategories.LEVELED_ITEM)).filter(Objects::nonNull).flatMap(Collection::stream).filter(x -> !x.getAvailableComponents().isEmpty()).forEachOrdered(x -> {
            list.addAll(x.getAvailableComponents());
            list.add(EMPTY_LINE);
        });
        List<AbstractTextBlock> additions = collect.get((Object)BlockCategories.ADDITIONAL);
        if (additions != null) {
            for (AbstractTextBlock abstractTextBlock : additions) {
                if (abstractTextBlock == null || abstractTextBlock.getAvailableComponents().isEmpty()) continue;
                list.addAll(abstractTextBlock.getAvailableComponents());
                list.add(EMPTY_LINE);
            }
        }
        Stream.of(collect.get((Object)BlockCategories.RARITY), collect.get((Object)BlockCategories.DURABILITY), collect.get((Object)BlockCategories.SALVAGE)).filter(Objects::nonNull).map(x -> (AbstractTextBlock)x.get(0)).filter(x -> !x.getAvailableComponents().isEmpty()).forEachOrdered(x -> list.addAll(x.getAvailableComponents()));
        list.add(EMPTY_LINE);
        Optional.ofNullable(collect.get((Object)BlockCategories.OPERATION)).ifPresent(x -> {
            for (AbstractTextBlock text : x) {
                list.addAll(text.getAvailableComponents());
            }
        });
        while (((Component)list.get(list.size() - 1)).getString().isBlank()) {
            list.remove(list.size() - 1);
        }
        List<Component> postEditList = TooltipUtils.splitLongText(list);
        postEditList = TooltipUtils.removeDoubleBlankLines(postEditList);
        return postEditList;
    }

    public static enum BlockCategories {
        NAME,
        RARITY,
        REQUIREMENT,
        STAT,
        DURABILITY,
        USAGE,
        LEVELED_ITEM,
        OPERATION,
        SALVAGE,
        ADDITIONAL;

    }
}

