/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.screens.stat_gui;

import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.StatGuiGroup;
import com.robertx22.mine_and_slash.gui.bases.BaseScreen;
import com.robertx22.mine_and_slash.gui.bases.INamedScreen;
import com.robertx22.mine_and_slash.gui.screens.stat_gui.IStatInfoButton;
import com.robertx22.mine_and_slash.gui.screens.stat_gui.StatGuiGroupSection;
import com.robertx22.mine_and_slash.gui.screens.stat_gui.StatInfoButton;
import com.robertx22.mine_and_slash.gui.screens.stat_gui.StatPanelButton;
import com.robertx22.mine_and_slash.gui.screens.stat_gui.StatSectionButton;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ClientOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class StatScreen
extends BaseScreen
implements INamedScreen {
    static ResourceLocation BG = SlashRef.guiId("stat_gui/background");
    private static int SEARCH_WIDTH = 100;
    private static int SEARCH_HEIGHT = 14;
    public static EditBox SEARCH = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, SEARCH_WIDTH, SEARCH_HEIGHT, (Component)Component.m_237115_((String)"fml.menu.mods.search"));
    int currentElement = 0;
    public List<Stat> stats = new ArrayList<Stat>();
    public List<Stat> searched = new ArrayList<Stat>();

    public StatScreen() {
        super(199, 222);
    }

    public void m_88315_(GuiGraphics gui, int x, int y, float ticks) {
        gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        gui.m_280218_(BG, this.mc.m_91268_().m_85445_() / 2 - this.sizeX / 2, this.mc.m_91268_().m_85446_() / 2 - this.sizeY / 2, 0, 0, this.sizeX, this.sizeY);
        super.m_88315_(gui, x, y, ticks);
        SEARCH.m_252865_(this.guiLeft - SEARCH_WIDTH / 2 + this.sizeX / 2);
        SEARCH.m_253211_(this.guiTop - SEARCH_HEIGHT - 5);
        SEARCH.m_88315_(gui, 0, 0, 0.0f);
    }

    public void setupStatButtons() {
        this.f_169369_.removeIf(x -> !(x instanceof EditBox));
        this.m_6702_().removeIf(x -> !(x instanceof EditBox));
        int secX = this.guiLeft + 9;
        int secY = this.guiTop + 18;
        for (StatGuiGroupSection sec : StatGuiGroupSection.values()) {
            this.publicAddButton(new StatSectionButton(this, sec, secX, secY));
            secY += StatSectionButton.ySize + 2;
        }
        int x2 = this.guiLeft + 30;
        int y = this.guiTop + 16;
        int spaceleft = 143;
        EntityData data = Load.Unit((Entity)ClientOnly.getPlayer());
        for (int i = this.currentElement; i < this.currentElement + 15; ++i) {
            StatData stat;
            Stat entry;
            int ysize;
            if (i >= this.stats.size() || this.searched.size() <= i || spaceleft < (ysize = (entry = this.searched.get(i)).getStatGuiPanelButtonYSize() + 3) || (stat = data.getUnit().getCalculatedStat(entry)).GetStat() == null) continue;
            this.publicAddButton(new StatPanelButton(this, stat, x2, y));
            y += ysize;
            spaceleft -= ysize;
        }
    }

    public boolean m_6050_(double num1, double num2, double num3) {
        this.setCurrentElement((int)((double)this.currentElement - num3));
        return super.m_6050_(num1, num2, num3);
    }

    public void setCurrentElement(int element) {
        this.currentElement = MathHelper.clamp(element, 0, this.searched.size());
        this.setupStatButtons();
    }

    public void setInfo(StatData stat) {
        this.f_169369_.removeIf(x -> x instanceof IStatInfoButton);
        this.m_6702_().removeIf(x -> x instanceof IStatInfoButton);
        int x2 = this.guiLeft + 38;
        int y = this.guiTop + 172;
        for (StatInfoButton.StatInfoType type : StatInfoButton.StatInfoType.values()) {
            if (!type.shouldShow(stat)) continue;
            this.publicAddButton(new StatInfoButton(type, stat, x2, y));
            x2 += StatInfoButton.xSize + 12;
        }
    }

    public void m_86600_() {
        SEARCH.m_94120_();
    }

    public void showStats(List<Stat> stats, boolean replaceSaved) {
        if (replaceSaved) {
            this.stats = stats;
        }
        this.searched = stats;
        this.currentElement = 0;
        this.setupStatButtons();
    }

    public List<Stat> getAllStats() {
        List stats = Load.Unit((Entity)ClientOnly.getPlayer()).getUnit().getStats().stats.values().stream().filter(x -> x.GetStat().show_in_gui).map(x -> x.GetStat()).collect(Collectors.toList());
        List ungrouped = stats.stream().filter(x -> !x.gui_group.isValid()).collect(Collectors.toList());
        ArrayList grouped = new ArrayList();
        for (StatGuiGroup group : StatGuiGroup.values()) {
            if (!group.isValid()) continue;
            stats.stream().filter(x -> x.gui_group == group).findFirst().ifPresent(x -> grouped.add(x));
        }
        ArrayList<Stat> all = new ArrayList<Stat>();
        all.addAll(grouped);
        all.addAll(ungrouped);
        return all;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        SEARCH.m_93692_(false);
        SEARCH.m_94190_(true);
        this.publicAddButton(SEARCH);
        SEARCH.m_94151_(x -> this.showStats(this.stats.stream().filter(s -> {
            String name = s.locName().getString();
            return name.toLowerCase(Locale.ROOT).contains(x.toLowerCase(Locale.ROOT));
        }).collect(Collectors.toList()), false));
        this.showStats(StatGuiGroupSection.CORE.getStats((Player)this.mc.f_91074_), true);
    }

    @Override
    public ResourceLocation iconLocation() {
        return SlashRef.guiId("main_hub/icons/stats");
    }

    @Override
    public Words screenName() {
        return Words.Stats;
    }
}

