/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.screens.character_screen;

import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.main.Packets;
import com.robertx22.library_of_exile.utils.RenderUtils;
import com.robertx22.library_of_exile.utils.TextUTIL;
import com.robertx22.library_of_exile.wrappers.ExileText;
import com.robertx22.mine_and_slash.aoe_data.database.stats.DefenseStats;
import com.robertx22.mine_and_slash.aoe_data.database.stats.OffenseStats;
import com.robertx22.mine_and_slash.aoe_data.database.stats.ResourceStats;
import com.robertx22.mine_and_slash.aoe_data.database.stats.SpellChangeStats;
import com.robertx22.mine_and_slash.aoe_data.database.stats.old.DatapackStats;
import com.robertx22.mine_and_slash.characters.gui.CharacterSelectScreen;
import com.robertx22.mine_and_slash.database.data.game_balance_config.PlayerPointsType;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.stats.CoreStat;
import com.robertx22.mine_and_slash.database.data.stats.effects.defense.MaxElementalResist;
import com.robertx22.mine_and_slash.database.data.stats.types.core_stats.AllAttributes;
import com.robertx22.mine_and_slash.database.data.stats.types.defense.Armor;
import com.robertx22.mine_and_slash.database.data.stats.types.defense.ArmorPenetration;
import com.robertx22.mine_and_slash.database.data.stats.types.defense.BlockChance;
import com.robertx22.mine_and_slash.database.data.stats.types.defense.DodgeRating;
import com.robertx22.mine_and_slash.database.data.stats.types.generated.ElementalPenetration;
import com.robertx22.mine_and_slash.database.data.stats.types.generated.ElementalResist;
import com.robertx22.mine_and_slash.database.data.stats.types.offense.SkillDamage;
import com.robertx22.mine_and_slash.database.data.stats.types.offense.WeaponDamage;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.energy.Energy;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.energy.EnergyRegen;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.health.Health;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.health.HealthRegen;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.magic_shield.MagicShield;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.magic_shield.MagicShieldRegen;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.mana.Mana;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.mana.ManaRegen;
import com.robertx22.mine_and_slash.database.data.talent_tree.TalentTree;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.bases.BaseScreen;
import com.robertx22.mine_and_slash.gui.bases.INamedScreen;
import com.robertx22.mine_and_slash.gui.buttons.CharacterStatsButtons;
import com.robertx22.mine_and_slash.gui.buttons.FavorButton;
import com.robertx22.mine_and_slash.gui.buttons.ProfessionLevelsButton;
import com.robertx22.mine_and_slash.gui.inv_gui.GuiInventoryGrids;
import com.robertx22.mine_and_slash.gui.screens.OpenInvGuiScreen;
import com.robertx22.mine_and_slash.gui.screens.OpenJewelsScreen;
import com.robertx22.mine_and_slash.gui.screens.OpenSkillGems;
import com.robertx22.mine_and_slash.gui.screens.character_screen.HubStatButton;
import com.robertx22.mine_and_slash.gui.screens.character_screen.MainHubButton;
import com.robertx22.mine_and_slash.gui.screens.character_screen.PlayerGearButton;
import com.robertx22.mine_and_slash.gui.screens.skill_tree.AscendancyTree;
import com.robertx22.mine_and_slash.gui.screens.skill_tree.TalentsScreen;
import com.robertx22.mine_and_slash.gui.screens.spell.SpellSchoolScreen;
import com.robertx22.mine_and_slash.gui.screens.stat_gui.StatScreen;
import com.robertx22.mine_and_slash.gui.wiki.BestiaryScreen;
import com.robertx22.mine_and_slash.prophecy.gui.ProphecyScreen;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.localization.Gui;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import com.robertx22.mine_and_slash.vanilla_mc.packets.AllocateStatPacket;
import com.robertx22.mine_and_slash.vanilla_mc.packets.proxies.OpenGuiWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class MainHubScreen
extends BaseScreen
implements INamedScreen {
    private static final ResourceLocation LEFT = new ResourceLocation("mmorpg", "textures/gui/main_hub/buttons_backwards.png");
    static ResourceLocation RIGHT = new ResourceLocation("mmorpg", "textures/gui/main_hub/buttons.png");
    static int sizeX = 256;
    static int sizeY = 219;
    Minecraft mc = Minecraft.m_91087_();
    public static List<List<Stat>> leftStats = new ArrayList<List<Stat>>();
    public static List<List<Stat>> rightStats = new ArrayList<List<Stat>>();
    public static HashMap<StatType, List<List<Stat>>> STAT_MAP = new HashMap();
    private static final ResourceLocation BACKGROUND;
    static int PLUS_BUTTON_SIZE_X;
    static int PLUS_BUTTON_SIZE_Y;

    static <T extends Stat> void addTo(StatType type, List<T> stats) {
        List list = stats.stream().map(x -> x).collect(Collectors.toList());
        if (!STAT_MAP.containsKey((Object)type)) {
            STAT_MAP.put(type, new ArrayList());
        }
        STAT_MAP.get((Object)type).add(list);
    }

    static <T extends Stat> void addRemaining(StatType type) {
        ArrayList<Stat> list = new ArrayList<Stat>();
        for (List<List<Stat>> l : STAT_MAP.values()) {
            for (List<Stat> s : l) {
                for (Stat st : s) {
                    list.add(st);
                }
            }
        }
        List v = Load.Unit((Entity)Minecraft.m_91087_().f_91074_).getUnit().getStats().stats.values().stream().filter(x -> x.isNotZero() && x.GetStat() != null && x.GetStat().show_in_gui && !x.GetStat().is_long && list.stream().noneMatch(e -> e.GUID().equals(x.getId()))).map(t -> t.GetStat()).collect(Collectors.toList());
        if (!STAT_MAP.containsKey((Object)type)) {
            STAT_MAP.put(type, new ArrayList());
        }
        STAT_MAP.get((Object)StatType.MISC).add(v);
    }

    public MainHubScreen() {
        super(sizeX, sizeY);
    }

    @Override
    public ResourceLocation iconLocation() {
        return new ResourceLocation("mmorpg", "textures/gui/main_hub/icons/stat_overview.png");
    }

    @Override
    public boolean m_7043_() {
        return false;
    }

    public boolean m_6348_(double x, double y, int ticks) {
        return super.m_6348_(x, y, ticks);
    }

    @Override
    public Words screenName() {
        return Words.Character;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        int xpos = this.guiLeft + 75;
        int ypos = this.guiTop + 25;
        xpos = this.guiLeft + 78;
        ypos = this.guiTop + 105;
        int YSEP = 20;
        xpos = this.guiLeft + 28;
        ypos = this.guiTop + 21;
        this.publicAddButton(new AllocateStatButton(AllAttributes.STR_ID, xpos, ypos));
        this.publicAddButton(new AllocateStatButton(AllAttributes.INT_ID, xpos, ypos += YSEP));
        this.publicAddButton(new AllocateStatButton(AllAttributes.DEX_ID, xpos, ypos += YSEP));
        xpos = this.guiLeft + 12;
        ypos = this.guiTop + 90;
        ArrayList<INamedScreen> rightButtons = new ArrayList<INamedScreen>();
        rightButtons.add(new SpellSchoolScreen());
        rightButtons.add(new OpenSkillGems());
        rightButtons.add(new TalentsScreen());
        if (Load.player((Player)this.mc.f_91074_).talents.getAllocatedPoints(TalentTree.SchoolType.TALENTS) > 0) {
            rightButtons.add(new AscendancyTree());
        }
        rightButtons.add(new OpenJewelsScreen());
        if (WorldUtils.isMapWorldClass((Level)this.mc.f_91073_)) {
            if (Load.player((Player)this.mc.f_91074_).prophecy.affixOffers.isEmpty()) {
                rightButtons.add(new ProphecyScreen());
            } else {
                rightButtons.add(OpenGuiWrapper.getProphecyCardsScreen());
            }
        }
        ArrayList<Object> leftButtons = new ArrayList<Object>();
        leftButtons.add(new BestiaryScreen());
        leftButtons.add(new CharacterSelectScreen());
        leftButtons.add(new OpenInvGuiScreen(Words.Salvaging, "salvage", GuiInventoryGrids.ofSalvageConfig()));
        leftButtons.add(new OpenInvGuiScreen(Words.Configs, "configs", GuiInventoryGrids.ofConfigs()));
        leftButtons.add(new StatScreen());
        this.publicAddButton(new FavorButton(this.guiLeft + sizeX / 2 - FavorButton.FAVOR_BUTTON_SIZE_X / 2, this.guiTop - FavorButton.FAVOR_BUTTON_SIZE_Y));
        this.publicAddButton(new ProfessionLevelsButton(this.guiLeft + sizeX / 2 - ProfessionLevelsButton.SX / 2, this.guiTop + 147));
        int x = this.guiLeft + sizeX - 1;
        int y = this.guiTop + 20;
        for (INamedScreen iNamedScreen : rightButtons) {
            this.publicAddButton(new MainHubButton(true, RIGHT, iNamedScreen, x, y));
            y += MainHubButton.ySize + 0;
        }
        x = this.guiLeft - MainHubButton.xSize;
        y = this.guiTop + 20;
        for (INamedScreen iNamedScreen : leftButtons) {
            this.publicAddButton(new MainHubButton(false, LEFT, iNamedScreen, x, y));
            y += MainHubButton.ySize + 0;
        }
        int xp = this.guiLeft + 195;
        int n = this.guiTop + 20;
        int i = 0;
        for (StatType type : StatType.values()) {
            int n2;
            this.publicAddButton(new CharacterStatsButtons(type, xp, n2));
            n2 += 20;
            if (++i != 3) continue;
            xp += 25;
            n2 = this.guiTop + 20;
        }
        int statx = 17;
        int staty = 103;
        for (List<Stat> stat : leftStats) {
            this.addStatButton(false, statx, staty, stat);
            statx += HubStatButton.xSize + 5;
        }
        statx = 200;
        staty = 103;
        for (List<Stat> stat : rightStats) {
            this.addStatButton(true, statx, staty, stat);
            statx -= HubStatButton.xSize + 5;
        }
        this.publicAddButton(new PlayerGearButton((Player)this.mc.f_91074_, this, this.guiLeft + sizeX / 2 - PlayerGearButton.xSize / 2, this.guiTop + 10));
    }

    void addStatButton(boolean isright, int x, int y, List<Stat> stats) {
        int yadd = 0;
        for (Stat stat : stats) {
            StatData statdata = Load.Unit((Entity)this.mc.f_91074_).getUnit().getCalculatedStat(stat);
            this.publicAddButton(new HubStatButton(isright, statdata, this.guiLeft + x, this.guiTop + y + yadd));
            yadd += MainHubButton.ySize;
        }
    }

    public void m_88315_(GuiGraphics gui, int x, int y, float ticks) {
        ResourceLocation loc = BACKGROUND;
        gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        gui.m_280218_(loc, this.mc.m_91268_().m_85445_() / 2 - sizeX / 2, this.mc.m_91268_().m_85446_() / 2 - sizeY / 2, 0, 0, sizeX, sizeY);
        super.m_88315_(gui, x, y, ticks);
        int p = PlayerPointsType.STATS.getFreePoints((Player)this.mc.f_91074_);
        if (p > 0) {
            MutableComponent points = Gui.STATS_POINTS.locName().m_130946_(String.valueOf(p));
            gui.m_280430_(this.mc.f_91062_, (Component)points, this.guiLeft + 40 - this.mc.f_91062_.m_92852_((FormattedText)points) / 2, this.guiTop + 10, ChatFormatting.GREEN.m_126665_().intValue());
        }
        int lvl = Load.player((Player)this.mc.f_91074_).miscInfo.area_lvl;
        MutableComponent areaLevel = Gui.AREA_LEVEL.locName().m_130946_(String.valueOf(lvl));
        gui.m_280430_(this.mc.f_91062_, (Component)areaLevel, this.guiLeft + sizeX / 2 - this.mc.f_91062_.m_92852_((FormattedText)areaLevel) / 2, this.guiTop + sizeY + 5, ChatFormatting.YELLOW.m_126665_().intValue());
    }

    static {
        MainHubScreen.addTo(StatType.RESOURCE, Arrays.asList(Health.getInstance(), HealthRegen.getInstance(), MagicShield.getInstance(), MagicShieldRegen.getInstance(), Mana.getInstance(), ManaRegen.getInstance(), Energy.getInstance(), EnergyRegen.getInstance()));
        MainHubScreen.addTo(StatType.RESOURCE, Arrays.asList(DatapackStats.STR, DatapackStats.INT, DatapackStats.DEX));
        MainHubScreen.addTo(StatType.DAMAGE, Arrays.asList(WeaponDamage.getInstance(), SkillDamage.getInstance()));
        MainHubScreen.addTo(StatType.DAMAGE, OffenseStats.STYLE_DAMAGE.getAll());
        MainHubScreen.addTo(StatType.DAMAGE, Arrays.asList(OffenseStats.ACCURACY.get(), OffenseStats.CRIT_CHANCE.get(), OffenseStats.CRIT_DAMAGE.get()));
        MainHubScreen.addTo(StatType.DAMAGE, Arrays.asList(SpellChangeStats.COOLDOWN_REDUCTION.get(), SpellChangeStats.CAST_SPEED.get()));
        MainHubScreen.addTo(StatType.ELE_DAMAGE, OffenseStats.ELEMENTAL_DAMAGE.getAll().stream().filter(x -> x.getElement().isValid()).collect(Collectors.toList()));
        MainHubScreen.addTo(StatType.ELE_DAMAGE, OffenseStats.ELEMENTAL_SPELL_DAMAGE.getAll().stream().filter(x -> x.getElement().isValid()).collect(Collectors.toList()));
        MainHubScreen.addTo(StatType.ELE_DAMAGE, Arrays.asList(ArmorPenetration.getInstance()));
        MainHubScreen.addTo(StatType.ELE_DAMAGE, new ElementalPenetration(Elements.Elemental).generateAllSingleVariations());
        MainHubScreen.addTo(StatType.DEFENSE, Arrays.asList(Armor.getInstance(), DodgeRating.getInstance(), BlockChance.getInstance()));
        MainHubScreen.addTo(StatType.DEFENSE, Arrays.asList(DefenseStats.DAMAGE_RECEIVED.get()));
        MainHubScreen.addTo(StatType.DEFENSE, Arrays.asList(DefenseStats.DAMAGE_REDUCTION.get()));
        MainHubScreen.addTo(StatType.DEFENSE, Arrays.asList(DefenseStats.DAMAGE_REDUCTION_CHANCE.get()));
        MainHubScreen.addTo(StatType.DEFENSE, new ElementalResist(Elements.Elemental).generateAllSingleVariations());
        MainHubScreen.addTo(StatType.DEFENSE, new MaxElementalResist(Elements.Elemental).generateAllSingleVariations());
        MainHubScreen.addTo(StatType.RECOVERY, Arrays.asList(ResourceStats.HEAL_STRENGTH.get(), ResourceStats.HEALING_RECEIVED.get()));
        MainHubScreen.addTo(StatType.RECOVERY, Arrays.asList(ResourceStats.LIFESTEAL.get(), ResourceStats.MANASTEAL.get(), ResourceStats.SPELL_LIFESTEAL.get(), ResourceStats.SPELL_MSSTEAL.get(), ResourceStats.DOT_LIFESTEAL.get()));
        MainHubScreen.addTo(StatType.RECOVERY, ResourceStats.RESOURCE_ON_HIT.getAll());
        MainHubScreen.addTo(StatType.RECOVERY, ResourceStats.RESOURCE_ON_KILL.getAll());
        MainHubScreen.addTo(StatType.RECOVERY, Arrays.asList(ResourceStats.INCREASED_LEECH.get()));
        MainHubScreen.addTo(StatType.RECOVERY, ResourceStats.LEECH_CAP.getAll());
        MainHubScreen.addRemaining(StatType.MISC);
        leftStats.add(Arrays.asList(Health.getInstance(), MagicShield.getInstance(), Mana.getInstance(), Energy.getInstance()));
        leftStats.add(Arrays.asList(HealthRegen.getInstance(), MagicShieldRegen.getInstance(), ManaRegen.getInstance(), EnergyRegen.getInstance()));
        rightStats.add(Arrays.asList(new ElementalResist(Elements.Fire), new ElementalResist(Elements.Cold), new ElementalResist(Elements.Nature), new ElementalResist(Elements.Shadow)));
        rightStats.add(Arrays.asList(OffenseStats.CRIT_CHANCE.get(), OffenseStats.CRIT_DAMAGE.get(), Armor.getInstance(), DodgeRating.getInstance()));
        BACKGROUND = new ResourceLocation("mmorpg", "textures/gui/stats.png");
        PLUS_BUTTON_SIZE_X = 13;
        PLUS_BUTTON_SIZE_Y = 13;
    }

    public static enum StatType {
        RESOURCE("resource"),
        DAMAGE("damage"),
        ELE_DAMAGE("ele_damage"),
        DEFENSE("defense"),
        RECOVERY("recovery"),
        MISC("misc");

        String id;

        private StatType(String id) {
            this.id = id;
        }

        public ResourceLocation getIcon() {
            return new ResourceLocation("mmorpg", "textures/gui/stat_groups/" + this.id + ".png");
        }
    }

    public static class AllocateStatButton
    extends ImageButton {
        static int SIZEX = 18;
        static int SIZEY = 18;
        static ResourceLocation BUTTON_TEX = new ResourceLocation("mmorpg", "textures/gui/plus_button.png");
        Stat stat;

        public AllocateStatButton(String stat, int xPos, int yPos) {
            super(xPos, yPos, SIZEX, SIZEY, 0, 0, SIZEY, BUTTON_TEX, button -> {});
            this.stat = (Stat)ExileDB.Stats().get(stat);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.f_93623_ && this.f_93624_) {
                boolean bl = this.m_93680_(mouseX, mouseY);
                if (bl) {
                    this.m_7435_(Minecraft.m_91087_().m_91106_());
                    if (button == 0) {
                        Packets.sendToServer((MyPacket)new AllocateStatPacket(this.stat, AllocateStatPacket.ACTION.ALLOCATE));
                    }
                    if (button == 1) {
                        Packets.sendToServer((MyPacket)new AllocateStatPacket(this.stat, AllocateStatPacket.ACTION.REMOVE));
                    }
                    this.m_5716_(mouseX, mouseY);
                    return true;
                }
                return false;
            }
            return false;
        }

        public void setTooltipMod() {
            Minecraft mc = Minecraft.m_91087_();
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(this.stat.locName().m_130940_(ChatFormatting.GREEN));
            tooltip.add(ExileText.ofText((String)"").get());
            tooltip.addAll(((CoreStat)this.stat).getCoreStatTooltip(Load.Unit((Entity)mc.f_91074_), Load.Unit((Entity)mc.f_91074_).getUnit().getCalculatedStat(this.stat)));
            this.m_257544_(Tooltip.m_257550_((Component)TextUTIL.mergeList(tooltip)));
        }

        public void m_88315_(GuiGraphics gui, int x, int y, float f) {
            this.setTooltipMod();
            super.m_88315_(gui, x, y, f);
            Minecraft mc = Minecraft.m_91087_();
            String txt = "" + (int)Load.Unit((Entity)mc.f_91074_).getUnit().getCalculatedStat(this.stat).getValue();
            RenderUtils.render16Icon((GuiGraphics)gui, (ResourceLocation)this.stat.getIconForRendering(), (int)(this.m_252754_() - 17), (int)(this.m_252907_() + 1));
            gui.m_280137_(mc.f_91062_, txt, this.m_252754_() + SIZEX + 13, this.m_252907_() + 5, ChatFormatting.WHITE.m_126665_().intValue());
        }
    }
}

