/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.overlays.spell_hotbar;

import com.mojang.blaze3d.systems.RenderSystem;
import com.robertx22.library_of_exile.utils.CLOC;
import com.robertx22.library_of_exile.utils.GuiUtils;
import com.robertx22.mine_and_slash.capability.entity.CooldownsData;
import com.robertx22.mine_and_slash.config.forge.ClientConfigs;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.gui.overlays.EffectsOverlay;
import com.robertx22.mine_and_slash.gui.overlays.GuiPosition;
import com.robertx22.mine_and_slash.gui.screens.character_screen.MainHubScreen;
import com.robertx22.mine_and_slash.mmorpg.registers.client.KeybindsRegister;
import com.robertx22.mine_and_slash.mmorpg.registers.client.SpellKeybind;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ChatUtils;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.settings.KeyModifier;

public class SpellHotbarOverlay {
    private static final ResourceLocation SWAP_BUTTON = new ResourceLocation("mmorpg", "textures/gui/spells/swap_button.png");
    private static final ResourceLocation HOTBAR_TEX = new ResourceLocation("mmorpg", "textures/gui/spells/hotbar.png");
    private static final ResourceLocation HOTBAR_SWAP_TEX = new ResourceLocation("mmorpg", "textures/gui/spells/swap_hotbar.png");
    private static final ResourceLocation COOLDOWN_TEX = new ResourceLocation("mmorpg", "textures/gui/spells/cooldown.png");
    private static final ResourceLocation SPELL_READY_TEX = new ResourceLocation("mmorpg", "textures/gui/spells/spell_ready.png");
    private static final ResourceLocation SPELL_ON_COOLDOWN = new ResourceLocation("mmorpg", "textures/gui/spells/on_cooldown.png");
    private static final ResourceLocation CHARGE = new ResourceLocation("mmorpg", "textures/gui/spells/charge_icon.png");
    private static final ResourceLocation KEY_BG = new ResourceLocation("mmorpg", "textures/gui/spells/keybind_bg.png");
    private static final ResourceLocation MOD_BG = new ResourceLocation("mmorpg", "textures/gui/spells/modbg.png");
    int CHARGE_SIZE = 9;
    Minecraft mc = Minecraft.m_91087_();

    public void onHudRender(GuiGraphics gui) {
        try {
            if (this.mc.f_91066_.f_92063_) {
                return;
            }
            if (this.mc.f_91074_.m_5833_()) {
                return;
            }
            if (ChatUtils.isChatOpen()) {
                return;
            }
            if (Load.player((Player)this.mc.f_91074_) == null) {
                return;
            }
            int WIDTH = 22;
            int HEIGHT = 162;
            if (((Boolean)ClientConfigs.getConfig().HOTBAR_SWAPPING.get()).booleanValue()) {
                HEIGHT = 82;
            }
            RenderSystem.enableBlend();
            int x = 0;
            int y = this.mc.m_91268_().m_85446_() / 2 - HEIGHT / 2;
            this.renderHotbar(gui, x, y);
            int spells = (Boolean)ClientConfigs.getConfig().HOTBAR_SWAPPING.get() != false ? 4 : 8;
            for (int i = 0; i < spells; ++i) {
                int place = i;
                if (((Boolean)ClientConfigs.getConfig().HOTBAR_SWAPPING.get()).booleanValue() && SpellKeybind.IS_ON_SECONd_HOTBAR) {
                    place += 4;
                }
                this.renderCurrentSpell(place, i, gui);
            }
            RenderSystem.disableBlend();
            if (ClientConfigs.getConfig().GUI_POSITION.get() != GuiPosition.TOP_LEFT) {
                int offset = 0;
                if (!((Boolean)ClientConfigs.getConfig().HOTBAR_SWAPPING.get()).booleanValue()) {
                    offset = 80;
                }
                EffectsOverlay.render(3, y + 85 + offset, (Player)this.mc.f_91074_, gui, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renderCurrentSpell(int place, int num, GuiGraphics gui) {
        int WIDTH = 22;
        int HEIGHT = 162;
        if (((Boolean)ClientConfigs.getConfig().HOTBAR_SWAPPING.get()).booleanValue()) {
            HEIGHT = 82;
        }
        gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        boolean render = true;
        Spell spell = null;
        try {
            spell = Load.player((Player)this.mc.f_91074_).getSkillGemInventory().getHotbarGem(place).getSpell();
            if (spell == null) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            render = false;
        }
        if (!render) {
            return;
        }
        int x = 3;
        int y = this.mc.m_91268_().m_85446_() / 2 - HEIGHT / 2 + 3;
        y += num * 20;
        try {
            int xs = x;
            int ys = y;
            ResourceLocation tex = new ResourceLocation("");
            tex = Load.Unit((Entity)this.mc.f_91074_).getCooldowns().getCooldownTicks(spell.GUID()) > 1 ? SPELL_ON_COOLDOWN : SPELL_READY_TEX;
            gui.m_280163_(tex, xs, ys, 0.0f, 0.0f, 16, 16, 16, 16);
            if (spell != null) {
                gui.m_280163_(spell.getIconLoc(), xs, ys, 0.0f, 0.0f, 16, 16, 16, 16);
                if (spell.config.charges > 0) {
                    int charges = Load.player((Player)this.mc.f_91074_).spellCastingData.charges.getCharges(spell.config.charge_name);
                    if (charges == 0) {
                        float needed = spell.config.charge_regen;
                        float currentticks = Load.player((Player)this.mc.f_91074_).spellCastingData.charges.getCurrentTicksChargingOf(spell.config.charge_name);
                        float ticksleft = needed - currentticks;
                        float percent = ticksleft / needed;
                        percent = Mth.m_14036_((float)percent, (float)0.0f, (float)1.0f);
                        this.drawCooldown(gui, percent, xs, ys);
                    }
                    int chargex = x + 21;
                    for (int i = 0; i < charges; ++i) {
                        gui.m_280163_(CHARGE, chargex, y + 5, 0.0f, 0.0f, this.CHARGE_SIZE, this.CHARGE_SIZE, this.CHARGE_SIZE, this.CHARGE_SIZE);
                        chargex += this.CHARGE_SIZE + 1;
                    }
                } else {
                    int cdsec;
                    CooldownsData cds = Load.Unit((Entity)this.mc.f_91074_).getCooldowns();
                    float percent = (float)cds.getCooldownTicks(spell.GUID()) / (float)cds.getNeededTicks(spell.GUID());
                    if (cds.getCooldownTicks(spell.GUID()) > 1) {
                        percent = Mth.m_14036_((float)percent, (float)0.0f, (float)1.0f);
                        this.drawCooldown(gui, percent, xs, ys);
                    }
                    if ((cdsec = cds.getCooldownTicks(spell.GUID()) / 20) > 1) {
                        String stext = cdsec + "s";
                        GuiUtils.renderScaledText((GuiGraphics)gui, (int)(xs + 27), (int)(ys + 10), (float)0.75f, (String)stext, (ChatFormatting)ChatFormatting.YELLOW);
                    }
                }
                int xkey = xs + 15;
                int ykey = y + 14;
                int bgsize = 10;
                RenderSystem.enableBlend();
                float alpha = 0.75f;
                gui.m_280246_(alpha, alpha, alpha, alpha);
                gui.m_280163_(KEY_BG, xkey - 6, ykey - 6, 0.0f, 0.0f, bgsize, bgsize, bgsize, bgsize);
                gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                String txt = CLOC.translate((FormattedText)KeybindsRegister.getSpellHotbar((int)place).key.getKey().m_84875_()).toUpperCase(Locale.ROOT);
                txt = txt.substring(0, 1);
                if (KeybindsRegister.getSpellHotbar((int)place).key.m_90862_()) {
                    txt = "UNBOUND KEY";
                }
                GuiUtils.renderScaledText((GuiGraphics)gui, (int)(xkey - 1), (int)ykey, (float)1.0f, (String)txt, (ChatFormatting)ChatFormatting.GREEN);
                SpellKeybind key = KeybindsRegister.getSpellHotbar(place);
                if (key.key.getKeyModifier() != KeyModifier.NONE) {
                    RenderSystem.enableBlend();
                    gui.m_280246_(alpha, alpha, alpha, alpha);
                    gui.m_280163_(MOD_BG, xkey - 18, ykey - 6, 0.0f, 0.0f, 13, bgsize, 13, bgsize);
                    gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                    String modtext = KeybindsRegister.getSpellHotbar((int)place).key.getKeyModifier().toString().substring(0, 3);
                    GuiUtils.renderScaledText((GuiGraphics)gui, (int)(xkey - 11), (int)ykey, (float)0.6f, (String)modtext, (ChatFormatting)ChatFormatting.YELLOW);
                }
                RenderSystem.disableBlend();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawCooldown(GuiGraphics gui, float percent, int x, int y) {
        gui.m_280163_(COOLDOWN_TEX, x, y, 0.0f, 0.0f, 16, (int)(16.0f * percent), 16, 16);
    }

    private void renderHotbar(GuiGraphics gui, int x, int y) {
        int WIDTH = 22;
        int HEIGHT = 162;
        if (((Boolean)ClientConfigs.getConfig().HOTBAR_SWAPPING.get()).booleanValue()) {
            HEIGHT = 82;
        }
        gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        if (((Boolean)ClientConfigs.getConfig().HOTBAR_SWAPPING.get()).booleanValue()) {
            gui.m_280218_(HOTBAR_SWAP_TEX, x, y, 0, 0, WIDTH, HEIGHT);
            gui.m_280163_(SWAP_BUTTON, x, y - 11, 0.0f, 0.0f, 22, 11, 22, 11);
            Object txt = "Swap";
            if (this.mc.f_91080_ instanceof MainHubScreen) {
                txt = (String)txt + ":  " + CLOC.translate((FormattedText)KeybindsRegister.HOTBAR_SWAP.getKey().m_84875_()).toUpperCase(Locale.ROOT);
            }
            GuiUtils.renderScaledText((GuiGraphics)gui, (int)((int)((float)(x + 5) + (float)this.mc.f_91062_.m_92895_((String)txt) / 2.0f * 0.6f)), (int)(y - 5), (float)0.6f, (String)txt, (ChatFormatting)ChatFormatting.RED);
        } else {
            gui.m_280218_(HOTBAR_TEX, x, y, 0, 0, WIDTH, HEIGHT);
        }
    }
}

