/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.overlays;

import com.robertx22.library_of_exile.utils.GuiUtils;
import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffect;
import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffectInstanceData;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.text.DecimalFormat;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class EffectsOverlay {
    public static void render(int x, int y, Player p, GuiGraphics gui, boolean horizontal) {
        int size = 16;
        int spacing = 18;
        Minecraft mc = Minecraft.m_91087_();
        for (Map.Entry<String, ExileEffectInstanceData> en : Load.Unit((Entity)p).getStatusEffectsData().exileMap.entrySet()) {
            if (en.getValue().shouldRemove()) continue;
            ExileEffect eff = (ExileEffect)ExileDB.ExileEffects().get(en.getKey());
            gui.m_280411_(eff.getTexture(), x, y, size, size, 0.0f, 0.0f, size, size, size, size);
            gui.m_280056_(mc.f_91062_, "" + en.getValue().stacks, x, y, ChatFormatting.WHITE.m_126665_().intValue(), true);
            int ticks = en.getValue().ticks_left;
            int sec = ticks / 20;
            String text = sec + "s";
            if (sec > 60) {
                int min = sec / 60;
                text = min + "m";
            } else {
                DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.0");
                text = sec < 10 ? sec + "s" : DECIMAL_FORMAT.format((float)sec / 60.0f) + "m";
            }
            int yoff = 21;
            if (!horizontal) {
                yoff = 14;
            }
            GuiUtils.renderScaledText((GuiGraphics)gui, (int)(x + 9), (int)(y + yoff), (float)0.8f, (String)text, (ChatFormatting)ChatFormatting.YELLOW);
            if (horizontal) {
                x += spacing;
                continue;
            }
            y += spacing;
        }
    }
}

