/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.overlays;

import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.blood.BloodUser;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.uncommon.localization.Gui;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.HealthUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BarGuiType {
    NONE{

        @Override
        public float getCurrent(EntityData data, Player en) {
            return 0.0f;
        }

        @Override
        public float getMax(EntityData data, Player en) {
            return 0.0f;
        }

        @Override
        public ResourceLocation getTexture(EntityData data, Player en) {
            return SlashRef.id("empty");
        }
    }
    ,
    EXP{

        @Override
        public float getCurrent(EntityData data, Player en) {
            return data.getExp();
        }

        @Override
        public float getMax(EntityData data, Player en) {
            return data.getExpRequiredForLevelUp();
        }

        @Override
        public ResourceLocation getTexture(EntityData data, Player en) {
            return SlashRef.id("textures/gui/overlay/exp.png");
        }

        @Override
        public MutableComponent getText(EntityData data, Player en) {
            return Gui.STATUS_BAR_LEVEL.locName(data.getLevel(), (int)(this.getMulti(data, en) * 100.0f));
        }
    }
    ,
    ENERGY{

        @Override
        public float getCurrent(EntityData data, Player en) {
            return data.getResources().getEnergy();
        }

        @Override
        public float getMax(EntityData data, Player en) {
            return data.getUnit().energyData().getValue();
        }

        @Override
        public ResourceLocation getTexture(EntityData data, Player en) {
            return SlashRef.id("textures/gui/overlay/energy.png");
        }
    }
    ,
    MAGIC_SHIELD{

        @Override
        public float getCurrent(EntityData data, Player en) {
            return data.getResources().getMagicShield();
        }

        @Override
        public float getMax(EntityData data, Player en) {
            return data.getUnit().magicShieldData().getValue();
        }

        @Override
        public ResourceLocation getTexture(EntityData data, Player en) {
            return SlashRef.id("textures/gui/overlay/magic_shield.png");
        }

        @Override
        public boolean shouldRender(EntityData data, Player en) {
            return data.getUnit().magicShieldData().getValue() > 0.0f;
        }
    }
    ,
    MANA{

        @Override
        public float getCurrent(EntityData data, Player en) {
            if (data.getUnit().isBloodMage()) {
                return data.getResources().getBlood();
            }
            return data.getResources().getMana();
        }

        @Override
        public float getMax(EntityData data, Player en) {
            if (data.getUnit().isBloodMage()) {
                return data.getUnit().bloodData().getValue();
            }
            return data.getUnit().manaData().getValue();
        }

        @Override
        public ResourceLocation getTexture(EntityData data, Player en) {
            if (data.getUnit().getCalculatedStat(BloodUser.getInstance()).getValue() > 0.0f) {
                return SlashRef.id("textures/gui/overlay/blood.png");
            }
            return SlashRef.id("textures/gui/overlay/mana.png");
        }
    }
    ,
    HEALTH{

        @Override
        public float getCurrent(EntityData data, Player en) {
            return HealthUtils.getCurrentHealth((LivingEntity)en);
        }

        @Override
        public float getMax(EntityData data, Player en) {
            return HealthUtils.getMaxHealth((LivingEntity)en);
        }

        @Override
        public ResourceLocation getTexture(EntityData data, Player en) {
            return SlashRef.id("textures/gui/overlay/health.png");
        }
    }
    ,
    HUNGER{

        @Override
        public float getCurrent(EntityData data, Player en) {
            return en.m_36324_().m_38702_();
        }

        @Override
        public float getMax(EntityData data, Player en) {
            return 20.0f;
        }

        @Override
        public ResourceLocation getTexture(EntityData data, Player en) {
            return SlashRef.id("textures/gui/overlay/hunger.png");
        }

        @Override
        public MutableComponent getText(EntityData data, Player en) {
            return Gui.STATUS_BAR_HUGER.locName((int)this.getCurrent(data, en), (int)en.m_36324_().m_38722_());
        }
    }
    ,
    AIR{

        @Override
        public float getCurrent(EntityData data, Player en) {
            return en.m_20146_();
        }

        @Override
        public float getMax(EntityData data, Player en) {
            return en.m_6062_();
        }

        @Override
        public ResourceLocation getTexture(EntityData data, Player en) {
            return SlashRef.id("textures/gui/overlay/air.png");
        }

        @Override
        public boolean shouldRender(EntityData data, Player en) {
            return this.getCurrent(data, en) < this.getMax(data, en);
        }
    };


    public float getMulti(EntityData data, Player en) {
        return Math.min(this.getCurrent(data, en) / this.getMax(data, en), 1.0f);
    }

    public MutableComponent getText(EntityData data, Player en) {
        return Component.m_237113_((String)((int)this.getCurrent(data, en) + "/" + (int)this.getMax(data, en)));
    }

    public ResourceLocation getIcon(EntityData data, Player en) {
        return new ResourceLocation(this.getTexture(data, en).toString().replaceAll(".png", "_icon.png"));
    }

    public boolean shouldRender(EntityData data, Player en) {
        return true;
    }

    public abstract float getCurrent(EntityData var1, Player var2);

    public abstract float getMax(EntityData var1, Player var2);

    public abstract ResourceLocation getTexture(EntityData var1, Player var2);
}

