/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.inv_gui.actions.auto_salvage;

import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.gui.inv_gui.actions.GuiAction;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Gui;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ToggleAutoSalvageRarity
extends GuiAction {
    public SalvageType type;
    public GearRarity rarity;

    public ToggleAutoSalvageRarity(SalvageType type, GearRarity rarity) {
        this.type = type;
        this.rarity = rarity;
    }

    @Override
    public List<Component> getTooltip(Player p) {
        ArrayList<Component> list = new ArrayList<Component>();
        MutableComponent text = Component.m_237113_((String)"");
        text = Load.player((Player)p).config.salvage.checkRaritySalvageConfig(this.type, this.rarity.GUID()) ? Gui.SALVAGE_TIP_ON.locName(this.rarity.locName(), this.type.word.locName()).m_130940_(ChatFormatting.GREEN) : Gui.SALVAGE_TIP_OFF.locName(this.rarity.locName(), this.type.word.locName()).m_130940_(ChatFormatting.RED);
        list.add((Component)text);
        return list;
    }

    @Override
    public void doAction(Player p, Object data) {
        Load.player((Player)p).config.salvage.toggleRaritySalvageConfig(this.type, this.rarity.GUID());
        Load.player((Player)p).playerDataSync.setDirty();
    }

    @Override
    public void clientAction(Player p, Object obj) {
    }

    @Override
    public ResourceLocation getIcon() {
        return SlashRef.id("textures/gui/inv_gui/icons/" + this.type.name().toLowerCase(Locale.ROOT) + ".png");
    }

    @Override
    public ResourceLocation getBackGroundIcon() {
        return this.rarity.getGlintTextureFull();
    }

    @Override
    public void saveExtraData(FriendlyByteBuf buf) {
    }

    public Object loadExtraData(FriendlyByteBuf buf) {
        return null;
    }

    public String GUID() {
        return "auto_sal_" + this.type.name().toLowerCase(Locale.ROOT) + this.rarity.GUID();
    }

    public static enum SalvageType {
        GEAR(Words.Gear),
        JEWEL(Words.Jewel),
        SPELL(Words.SkillGem);

        public Words word;

        private SalvageType(Words word) {
            this.word = word;
        }
    }
}

