/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.event_hooks.my_events;

import com.robertx22.library_of_exile.events.base.EventConsumer;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.mine_and_slash.capability.entity.CooldownsData;
import com.robertx22.mine_and_slash.capability.player.PlayerData;
import com.robertx22.mine_and_slash.capability.player.data.PlayerBuffData;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class OnPlayerDeath
extends EventConsumer<ExileEvents.OnPlayerDeath> {
    public void accept(ExileEvents.OnPlayerDeath event) {
        try {
            Player player = event.player;
            CooldownsData cd = Load.Unit((Entity)player).getCooldowns();
            if (!cd.isOnCooldown("death_event")) {
                cd.setOnCooldown("death_event", 100);
                Load.Unit((Entity)player).setEquipsChanged();
                PlayerData data = Load.player(player);
                if (Load.Unit((Entity)player).getLevel() > (Integer)ServerContainer.get().DEATH_PENALTY_START_LEVEL.get()) {
                    Load.Unit((Entity)player).onDeathDoPenalty();
                    data.rested_xp.onDeath();
                    data.favor.onDeath(player);
                }
                data.deathStats.died = true;
                data.buff = new PlayerBuffData();
                data.playerDataSync.setDirty();
                MapData map = Load.mapAt(player.m_9236_(), player.m_20183_());
                if (map != null) {
                    map.reduceLives(player);
                    player.m_213846_((Component)Chats.MAP_DEATH_LIVES_LOSS.locName(map.getLives(player)).m_130940_(ChatFormatting.RED));
                    List<Component> reqDifference = map.map.getStatReq().getReqDifference(map.map.lvl, Load.Unit((Entity)player));
                    if (!reqDifference.isEmpty()) {
                        player.m_213846_((Component)Chats.NOT_MEET_MAP_REQ_FIRST_LINE.locName());
                        reqDifference.forEach(arg_0 -> ((Player)player).m_213846_(arg_0));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

