/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.event_hooks.my_events;

import com.robertx22.library_of_exile.components.EntityInfoComponent;
import com.robertx22.library_of_exile.events.base.EventConsumer;
import com.robertx22.library_of_exile.events.base.ExileEvent;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.database.data.EntityConfig;
import com.robertx22.mine_and_slash.database.data.league.LeagueMechanic;
import com.robertx22.mine_and_slash.database.data.league.LeagueStructure;
import com.robertx22.mine_and_slash.database.data.stats.types.misc.BonusExp;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.LootModifier;
import com.robertx22.mine_and_slash.loot.LootModifierEnum;
import com.robertx22.mine_and_slash.loot.LootModifiersList;
import com.robertx22.mine_and_slash.loot.LootUtils;
import com.robertx22.mine_and_slash.loot.MasterLootGen;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LevelUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TeamUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;

public class OnMobDeathDrops
extends EventConsumer<ExileEvents.OnMobDeath> {
    public void accept(ExileEvents.OnMobDeath onMobDeath) {
        block15: {
            LivingEntity mobKilled = onMobDeath.mob;
            try {
                if (mobKilled.m_9236_().f_46443_) {
                    return;
                }
                if (mobKilled instanceof Player) break block15;
                EntityData mobKilledData = Load.Unit((Entity)mobKilled);
                LivingEntity killerEntity = EntityInfoComponent.get((LivingEntity)mobKilled).getDamageStats().getHighestDamager((ServerLevel)mobKilled.m_9236_());
                if (killerEntity == null) {
                    try {
                        if (mobKilled.m_21225_().m_7639_() instanceof Player) {
                            killerEntity = (LivingEntity)mobKilled.m_21225_().m_7639_();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (killerEntity == null && EntityInfoComponent.get((LivingEntity)mobKilled).getDamageStats().getEnviroOrMobDmg() < mobKilled.m_21233_() / 2.0f) {
                    killerEntity = onMobDeath.killer;
                }
                if (killerEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)killerEntity;
                    EntityData playerData = Load.Unit((Entity)player);
                    EntityConfig config = ExileDB.getEntityConfig(mobKilled, mobKilledData);
                    float loot_multi = (float)config.loot_multi;
                    float exp_multi = (float)config.exp_multi;
                    if (loot_multi > 0.0f) {
                        if (WorldUtils.isDungeonWorld(mobKilled.m_9236_())) {
                            LeagueMechanic mech;
                            if (!Load.Unit((Entity)mobKilled).isValidMapMob()) {
                                if (MMORPG.RUN_DEV_TOOLS) {
                                    player.m_213846_((Component)Component.m_237113_((String)"Killed Mob wasn't properly spawned"));
                                }
                                return;
                            }
                            MapData map = Load.mapAt(mobKilled.m_9236_(), mobKilled.m_20183_());
                            if (map != null && !(mech = LeagueStructure.getMechanicFromPosition((ServerLevel)player.m_9236_(), mobKilled.m_20183_())).isEmpty()) {
                                LootInfo info = LootInfo.ofMobKilled((Player)player, mobKilled);
                                mech.onKillMob(map, info);
                            }
                        }
                        MasterLootGen.genAndDrop(mobKilled, (Player)player);
                    }
                    if (exp_multi > 0.0f) {
                        OnMobDeathDrops.GiveExp(mobKilled, (Player)player, playerData, mobKilledData, exp_multi);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void GiveExp(LivingEntity victim, Player killer, EntityData killerData, EntityData mobData, float multi) {
        Object map;
        float exp = LevelUtils.getBaseExpMobReward(mobData.getLevel());
        if (exp < 1.0f) {
            exp += 1.0f;
        }
        LootModifiersList mods = new LootModifiersList();
        mods.add(new LootModifier(LootModifierEnum.MOB_HEALTH, LootUtils.getMobHealthBasedLootMulti(victim)));
        mods.add(new LootModifier(LootModifierEnum.MOB_RARITY, mobData.getMobRarity().expMulti()));
        mods.add(new LootModifier(LootModifierEnum.ENTITY_DATAPACK, multi));
        mods.add(new LootModifier(LootModifierEnum.CONFIG, ((Double)ServerContainer.get().EXP_GAIN_MULTI.get()).floatValue()));
        mods.add(new LootModifier(LootModifierEnum.DIMENSION_LOOT, ExileDB.getDimensionConfig((LevelAccessor)victim.m_9236_()).exp_multi));
        mods.add(new LootModifier(LootModifierEnum.PLAYER_BONUS_EXP, killerData.getUnit().getCalculatedStat(BonusExp.getInstance()).getMultiplier()));
        mods.add(new LootModifier(LootModifierEnum.FAVOR, Load.player((Player)killer).favor.getLootExpMulti()));
        if (WorldUtils.isMapWorldClass(victim.m_9236_()) && (map = Load.mapAt(victim.m_9236_(), victim.m_20183_())) != null) {
            mods.add(new LootModifier(LootModifierEnum.ADVENTURE_MAP, ((MapData)map).map.getExpMulti()));
        }
        for (LootModifier mod : mods.all) {
            exp *= mod.multi;
        }
        exp = ((ExileEvents.OnMobExpDrop)ExileEvents.MOB_EXP_DROP.callEvents((ExileEvent)new ExileEvents.OnMobExpDrop((LivingEntity)victim, (float)exp))).exp;
        if ((int)exp > 0) {
            List<Player> list = TeamUtils.getOnlineTeamMembersInRange(killer);
            int members = list.size() - 1;
            if (members > 4) {
                members = 4;
            }
            float teamMulti = 1.0f + 0.2f * (float)members;
            exp *= teamMulti;
            exp /= (float)list.size();
            for (Player player : list) {
                int splitExp = (int)(exp * LootUtils.getLevelDistancePunishmentMulti(mobData.getLevel(), Load.Unit((Entity)player).getLevel()));
                if (splitExp <= 0) continue;
                Load.Unit((Entity)player).GiveExp(player, splitExp, mods);
            }
        }
    }
}

