/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.event_hooks.my_events;

import com.robertx22.library_of_exile.events.base.EventConsumer;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.mine_and_slash.capability.bases.EntityGears;
import com.robertx22.mine_and_slash.capability.entity.BossData;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.characters.PlayerStats;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class OnEntityTick
extends EventConsumer<ExileEvents.OnEntityTick> {
    public void accept(ExileEvents.OnEntityTick onEntityTick) {
        LivingEntity entity = onEntityTick.entity;
        try {
            BossData boss;
            if (entity.m_9236_().f_46443_) {
                return;
            }
            EntityData data = Load.Unit((Entity)entity);
            if (data == null) {
                return;
            }
            if (data.isSummon()) {
                data.summonedPetData.tick(entity);
            }
            data.ailments.onTick(entity);
            data.getStatusEffectsData().tick(entity);
            data.getCooldowns().onTicksPass(1);
            if (entity.f_19797_ % 20 == 0) {
                data.leech.onSecondUseLeeches(data);
            }
            if ((boss = data.getBossData()) != null) {
                boss.tick(entity);
            }
            if (entity instanceof Player) {
                OnEntityTick.checkGearChanged(entity);
                if (entity.f_19797_ % 100 == 0) {
                    Player p = (Player)entity;
                    for (Map.Entry<String, ResourceLocation> set : PlayerStats.REGISTERED_STATS.entrySet()) {
                        int max = Math.round(data.getUnit().getCalculatedStat(set.getKey()).getValue());
                        p.m_7166_(Stats.f_12988_.m_12902_((Object)PlayerStats.REGISTERED_STATS.get(set.getKey())));
                        p.m_6278_(Stats.f_12988_.m_12902_((Object)PlayerStats.REGISTERED_STATS.get(set.getKey())), max);
                    }
                }
            }
            data.gear.onTickTrySync((Entity)entity);
            data.sync.onTickTrySync((Entity)entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void checkGearChanged(LivingEntity entity) {
        if (entity.m_9236_().f_46443_) {
            return;
        }
        if (entity.m_21224_()) {
            return;
        }
        EntityData data = Load.Unit((Entity)entity);
        EntityGears gears = data.getCurrentGears();
        boolean calc = false;
        for (EquipmentSlot s : EquipmentSlot.values()) {
            ItemStack before;
            ItemStack now = entity.m_6844_(s);
            if (now != (before = gears.get(s))) {
                calc = true;
            }
            gears.put(s, now);
        }
        if (calc) {
            OnEntityTick.on$change(entity);
        }
    }

    private static void on$change(LivingEntity entity) {
        if (entity != null) {
            EntityData data = Load.Unit((Entity)entity);
            data.setEquipsChanged();
        }
    }
}

