/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.event_hooks.my_events;

import com.robertx22.mine_and_slash.a_libraries.curios.MyCurioUtils;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.event_hooks.damage_hooks.util.AttackInformation;
import com.robertx22.mine_and_slash.event_hooks.damage_hooks.util.WeaponFinderUtil;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.unit.GearData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CollectGearEvent {
    public static List<GearData> getAllGear(AttackInformation event, LivingEntity entity, EntityData unitdata) {
        ArrayList<GearData> list = new ArrayList<GearData>();
        Boolean hasWeapon = false;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            GearData data = CollectGearEvent.getDataFor(slot, entity, unitdata);
            list.add(data);
            if (data.slot != EquipmentSlot.MAINHAND) continue;
            if (data.gear == null) {
                ItemStack stack = WeaponFinderUtil.getWeapon(entity, null);
                data.gear = (GearItemData)StackSaving.GEARS.loadFrom(stack);
            }
            if (data.gear == null || !data.gear.GetBaseGearType().isWeapon()) continue;
            hasWeapon = true;
        }
        if (!hasWeapon.booleanValue() && event != null && event.weaponData != null) {
            list.add(new GearData(event.weapon, EquipmentSlot.MAINHAND, unitdata));
            hasWeapon = true;
        }
        if (entity instanceof Player) {
            MyCurioUtils.getAllSlots((Player)entity).forEach(x -> {
                GearData data = new GearData((ItemStack)x, null, unitdata);
                list.add(data);
            });
        }
        return list;
    }

    static GearData getDataFor(EquipmentSlot slot, LivingEntity en, EntityData data) {
        ItemStack stack = en.m_6844_(slot);
        return new GearData(stack, slot, data);
    }

    public static class CollectedGearStacks {
        public List<GearData> gears;
        public LivingEntity entity;
        public AttackInformation data;

        public CollectedGearStacks(LivingEntity entity, List<GearData> gears, AttackInformation data) {
            this.entity = entity;
            this.gears = gears;
            this.data = data;
            EntityData unitdata = Load.Unit((Entity)entity);
            gears.addAll(CollectGearEvent.getAllGear(data, entity, unitdata));
            gears.removeIf(x -> !x.isUsableBy(unitdata));
        }
    }
}

