/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.event_hooks.entity;

import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.database.data.EntityConfig;
import com.robertx22.mine_and_slash.database.data.rarities.MobRarity;
import com.robertx22.mine_and_slash.database.data.spells.summons.entity.SummonEntity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.saveclasses.unit.Unit;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.AllyOrEnemy;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;

public class OnMobSpawn {
    public static void onLoad(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        if (entity instanceof Player) {
            return;
        }
        if (WorldUtils.isMapWorldClass(entity.m_9236_()) && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (((Boolean)ServerContainer.get().DO_NOT_DESPAWN_MAP_MOBS.get()).booleanValue() && !(entity instanceof SummonEntity)) {
                int count = EntityFinder.start(entity, LivingEntity.class, entity.m_20182_()).radius(100.0).searchFor(AllyOrEnemy.all).build().size();
                if ((Integer)ServerContainer.get().DONT_MAKE_MAP_MOBS_PERSISTENT_IF_MOB_COUNT_IS_ABOVE.get() > count) {
                    mob.m_21530_();
                }
            }
        }
        OnMobSpawn.setupNewMobOnSpawn((LivingEntity)entity);
    }

    public static void setupNewMobOnSpawn(LivingEntity entity) {
        if (entity.m_9236_().f_46443_) {
            return;
        }
        EntityData endata = Load.Unit((Entity)entity);
        if (endata != null) {
            endata.setType();
            Player nearestPlayer = null;
            nearestPlayer = PlayerUtils.nearestPlayer((ServerLevel)entity.m_9236_(), entity);
            if (endata.needsToBeGivenStats()) {
                OnMobSpawn.setupNewMob(entity, endata, nearestPlayer);
                entity.m_5634_(2.1474836E9f);
            } else {
                if (endata.getUnit() == null) {
                    endata.setUnit(new Unit());
                }
                endata.getUnit().initStats();
                endata.setEquipsChanged();
            }
        }
    }

    public static Unit setupNewMob(LivingEntity entity, EntityData endata, Player nearestPlayer) {
        EntityConfig config = ExileDB.getEntityConfig(entity, endata);
        Unit mob = new Unit();
        mob.initStats();
        endata.SetMobLevelAtSpawn(nearestPlayer);
        String rar = endata.getRarity();
        rar = mob.randomRarity(endata.getLevel(), endata);
        if (config.hasSpecificRarity()) {
            rar = config.set_rar;
        }
        endata.setRarity(rar);
        MobRarity rarity = (MobRarity)ExileDB.MobRarities().get(rar);
        endata.getAffixData().randomizeAffixes(rarity);
        endata.setUnit(mob);
        endata.mobStatsAreSet();
        endata.setEquipsChanged();
        return mob;
    }
}

