/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.event_hooks.damage_hooks.util;

import com.google.common.base.Preconditions;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.event_hooks.damage_hooks.util.WeaponFinderUtil;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class AttackInformation {
    private ExileEvents.OnDamageEntity event;
    Mitigation mitigation;
    boolean canceled = false;
    LivingEntity targetEntity;
    LivingEntity attackerEntity;
    DamageSource damageSource;
    float amount;
    public ItemStack weapon;
    public GearItemData weaponData;

    public AttackInformation(ExileEvents.OnDamageEntity event, Mitigation miti, LivingEntity target, DamageSource source, float amount) {
        this.targetEntity = target;
        this.damageSource = source;
        this.amount = amount;
        this.mitigation = miti;
        this.event = event;
        this.weapon = WeaponFinderUtil.getWeapon((LivingEntity)source.m_7639_(), source.m_7640_());
        this.weaponData = (GearItemData)StackSaving.GEARS.loadFrom(this.weapon);
        Preconditions.checkArgument((boolean)(source.m_7639_() instanceof LivingEntity));
        this.attackerEntity = (LivingEntity)source.m_7639_();
    }

    public DamageSource getSource() {
        return this.damageSource;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setAmount(float f) {
        this.amount = f;
        if (this.event != null) {
            this.event.damage = f;
            this.event.canceled = !(f > 0.0f);
        }
    }

    public LivingEntity getTargetEntity() {
        return this.targetEntity;
    }

    public LivingEntity getAttackerEntity() {
        return this.attackerEntity;
    }

    public EntityData getAttackerEntityData() {
        return Load.Unit((Entity)this.attackerEntity);
    }

    public EntityData getTargetEntityData() {
        return Load.Unit((Entity)this.targetEntity);
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
        if (this.event != null) {
            this.event.canceled = canceled;
        }
    }

    public static enum Mitigation {
        PRE,
        POST;

    }
}

