/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.documentation.test;

import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.gear_types.bases.BaseGearType;
import com.robertx22.mine_and_slash.database.data.league.LeagueMechanic;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.data.unique_items.UniqueGear;
import com.robertx22.mine_and_slash.database.documentation.BooleanField;
import com.robertx22.mine_and_slash.database.documentation.DatabaseField;
import com.robertx22.mine_and_slash.database.documentation.GenericField;
import com.robertx22.mine_and_slash.database.documentation.IntegerField;
import com.robertx22.mine_and_slash.database.documentation.ItemField;
import com.robertx22.mine_and_slash.database.documentation.JsonField;
import com.robertx22.mine_and_slash.database.documentation.JsonIdentifierField;
import com.robertx22.mine_and_slash.database.documentation.WeightField;
import com.robertx22.mine_and_slash.database.documentation.test.JsonWrapper;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import java.util.HashMap;
import java.util.List;

public class UniqueGearWrapper
extends JsonWrapper<UniqueGear> {
    private UniqueGear uniq;
    public DatabaseField<BaseGearType> baseGear;
    public DatabaseField<GearRarity> rarity;
    public DatabaseField<LeagueMechanic> league;
    public BooleanField canBeRuned;
    public BooleanField replacesName;
    public ItemField forceItem;
    public JsonIdentifierField id;
    public WeightField weight;
    public IntegerField minTier;
    public GenericField<List<StatMod>> uniqueStats;

    public UniqueGearWrapper(UniqueGear x) {
        this.uniq = x;
        this.id = this.of("guid", new JsonIdentifierField(x.guid));
        this.uniqueStats = this.of("unique_stats", new GenericField<List<StatMod>>(x.unique_stats, "The stats of the unique. These stats are always the same for the unique, they only vary in numbers."));
        this.baseGear = this.of("base_gear", new DatabaseField(x.base_gear, ExileRegistryTypes.GEAR_TYPE));
        this.rarity = this.of("rarity", new DatabaseField(x.rarity, ExileRegistryTypes.GEAR_RARITY));
        this.league = this.of("league", new DatabaseField(x.league, ExileRegistryTypes.LEAGUE_MECHANIC));
        this.forceItem = this.of("force_item_id", new ItemField(x.force_item_id));
        this.weight = this.of("weight", new WeightField(x.weight));
        this.minTier = this.of("min_tier", new IntegerField(x.min_tier, "The minimum map tier this unique can drop from."));
        this.canBeRuned = this.of("runable", new BooleanField(x.runable, "Whether the Unique can have runes socketed on it."));
        this.replacesName = this.of("replaces_name", new BooleanField(x.replaces_name, "If name is replaced, it will only use unique's lang entry, if it's not replaced, it will add the base gear type to the name."));
        this.league.setCanBeEmpty();
        this.testFieldsExist();
    }

    @Override
    public HashMap<String, JsonField> getFieldMap() {
        return this.fieldMap;
    }

    @Override
    public UniqueGear getWrapped() {
        return this.uniq;
    }
}

